/**
 * @author Dharmendra.P
 * 
 */
Ext.define('Academia.view.coursetransaction.studymaterialdistributionnew.StudentSmdSearch',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentsmdsearch',
	plugins : "formlabelrequired",
	method : 'POST',
	standardSubmit : false,
	cls:'customSearchPanel',
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	items : [
{
	xtype : 'fieldcontainer',
	width: 'auto',
	layout : {
		type : 'hbox'
	},
	defaults : {
		width : 450,
		labelAlign : 'top'
	},
	items : [{

		xtype: 'multiselectcombofield',
		width: 460,
		//height: 'auto',
		name: 'multiselectAcademyLocation',
		cls: 'multiselectAcademyLocation',
		itemId: 'multiselectAcademyLocationId',
		allowBlank : false,
		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
//		translationKey: 'ACADEMY_LOCATION',
		store:'common.AcademyLocationNameSeparated',
		displayField:'value',
		valueField:'id',
		matchFieldWidth:true,
		queryMode:'local',
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.width = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}' +
				'</div>';
			}
		}
	
	}]
	},
	         
	         {
			xtype : 'fieldcontainer',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 450,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name:'studentName',
				itemId:'studentId',
				store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
				fieldLabel:getCourseTxCommonTranslation('STUDENT_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				allowBlank:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			}
			]},{
	            xtype: 'fieldcontainer',
	            width: 'auto',
	            items: [{
	                xtype: 'button',
	                text: getCommonTranslation('SEARCH'),
	                itemId: 'searchBtn',
	                buttonAlign: 'left',
	                ui: 'CustomBtnSubmit',
	                formBind:true,
	                scale: CONSTANTS.BUTTONSIZE
	            },{
	                xtype: 'button',
	                text: getCourseTxCommonTranslation('RESET'),
	                itemId: 'resetBtn',
	                buttonAlign: 'left',
	                ui: 'CustomBtnCancel',
	                scale: CONSTANTS.BUTTONSIZE
	            }]
	        }]
//	}]
});