/**
 * @author sachin.bangar
 * 
 * This form is used for custom category
 */
Ext.define('Academia.view.customcategories.CustomCategoryForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.customcategoryform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'id_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'whetherCustomField',
        value: false
    }, {
        xtype: 'hidden',
        name: 'customFieldDataType',
        value: 'COMBOBOX'
    }, {
        xtype: 'hidden',
        name: 'whetherStandardMaster',
        value: false
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('ENTITY_NAME'),
            editable : false,
            allowBlank: false,
            name: 'customTableConfig',
            itemId: 'customTableConfigField',
            valueField: 'id',
            displayField: 'value',
            listeners: {
            	render: function(combo) {
                    var store = Ext.create('Academia.store.customcategories.TableConfigCategoryStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('COLUMN_NAME'),
            editable : false,
            allowBlank: false,
            disabled: true,
            name: 'columnMapping',
            itemId: 'columnNameField',
            valueField: 'id',
            displayField: 'value',
            listeners: {
            	render: function(combo) {
                    var store = Ext.create('Academia.store.customcategories.TableColumnConfigStore');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('CATEGORY_NAME'),
            itemId : 'categoryNameField',
            name: 'displayName',
            allowBlank: false
        }, {
            xtype: 'numberfield',
            fieldLabel: getCommonTranslation('DISPLAY_ORDER'),
            itemId : 'dispalyOrderField',
            name: 'displayOrder',
            minValue: 0,
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'checkboxfield',
            itemId : 'whetherMandatoryField',
            labelAlign: 'right',
            boxLabel: getCommonTranslation('CUSTOM_CATEGORY_MANDATORY'),
            name: 'whetherMandatory',
            inputValue: true,
            uncheckedValue: false
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});