/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show Custom Fields in grid 
 */
Ext.define('Academia.view.customfields.CustomFieldGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.customfieldgrid',
    border: true,
    title: getCommonTranslation('LIST_OF_CUSTOM_FIELDS'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        /*plugins: {
            ptype: 'gridviewdragdrop',
            dragText: getCommonTranslation('CHANGE_DISPLAY_SEQUENCE') //Change Display Sequence
		}*/
    },
    columns: [{
        header: getCommonTranslation('TABLE_NAME'),
        dataIndex: 'customTableConfigValue',
        sortable: true,
        flex: .3
    }, {
        header: getCommonTranslation('COLUMN_NAME'),
        dataIndex: 'columnMappingValue',
        sortable: true,
        flex: .3
    }, {
        header: getCommonTranslation('FIELD_TYPE'),
        dataIndex: 'customFieldDataType',
        sortable: true,
        flex: .3,
        renderer: function(value){
        	return getCommonTranslation(value);
        }
    }, {
        header: getCommonTranslation('FIELD_NAME'),
        dataIndex: 'displayName',
        sortable: true,
        flex: .3
    }, {
        header: getCommonTranslation('DISPLAY_ORDER'),
        dataIndex: 'displayOrder',
        sortable: true,
        flex: .3
    }, {
        header: getCommonTranslation('CUSTOM_CATEGORY_MANDATORY'),
        dataIndex: 'whetherMandatory',
        sortable: true,
        flex: .3,
        renderer: function(value){
        	var msg;
        	if(value){
        		msg = getCommonTranslation('TRUE');
        	}else{
        		msg = getCommonTranslation('FALSE');
        	}
        	return msg;
        }
    }],
    tbar: [{
        /*xtype: 'customcombobox',
        labelWidth: 80,
        width: 300,
        fieldLabel: getCommonTranslation('ENTITY_NAME'),
        name: 'customTableConfigId',
        itemId: 'gridCustomTableConfigField',
        editable: false,
        displayField: 'value',
        valueField: 'id',
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.customcategories.TableConfigCategoryMasterSearchStore');
                combo.bindStore(store);
            }
        }*/
	    xtype: 'customcombobox',
		name: 'customTableConfigId',
		fieldLabel:getCommonTranslation('ENTITY_NAME'),
		itemId: 'gridCustomTableConfigField',
		labelWidth: 80,
        width: 300,
		valueField: 'id',
		displayField: 'value',
		queryParam:'displayName',
		minChars:3,
		typeAhead:false,
		forceSelection:true,
	    allowBlank: false,
	    triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	    enableKeyEvents  : 'true',
	    hideTrigger:false,
	    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    triggerAction: '',
	    listConfig: {
	    	listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
	        loadingText: getCommonTranslation('SEARCHING'),
	        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        getInnerTpl: function() {
	            return '<div class="search-item">' +
	                '{value}' +
	            '</div>';
	        }
	    },
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.customcategories.TableConfigCategoryMasterSearchStore');
                combo.bindStore(store);
            }
        }
    }, {
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD_CUSTOM_FIELD_DETAILS'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT_CUSTOM_FIELD_DETAILS'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW_CUSTOM_FIELD_DETAILS'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE_CUSTOM_FIELD'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.customfields.CustomFieldStore');
    }
});