Ext.define('Academia.view.dashboard.dashlets.EnquiryCorporateFollowupDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.enquirycorporatefollowupdashlet',
    
	graphView:true,
    layout:'card',
    activeItem: 0, 
    autoScroll:false,
    cls:'EnquiryCorporateFollowUpDashletCLS dashlet',
    loadDashlet :function(){
	    var this$=this;
	    var view= this$.layout.getActiveItem();
	    var dates;
	    var toolbar; 
	    if(this.up('dashboardhomepage') == undefined){
			dates={
					startDate:Ext.ComponentQuery.query('extendeddatefilter[itemId=dateRangePicker]')[0].startDate,
					endDate:Ext.ComponentQuery.query('extendeddatefilter[itemId=dateRangePicker]')[0].endDate
			};
			if(!isNullOrEmpty(dates.startDate)){
				var tempStartDate=new Date(dates.startDate);
				dates.startDate=tempStartDate.getDate()+'-'+(tempStartDate.getMonth()+1)+'-'+tempStartDate.getFullYear();
			}else{
				dates.startDate=null;
			}
			if(!isNullOrEmpty(dates.endDate)){
				var tempEndDate=new Date(dates.endDate);
				dates.endDate=tempEndDate.getDate()+'-'+(tempEndDate.getMonth()+1)+'-'+tempEndDate.getFullYear();
			}else{
				dates.endDate=null;
			}
		}else{
			try{
				toolbar = this$.up('dashboardhomepage').down('toolbar');
				//dates=toolbar.down('#dateRangePicker').getValues();
				dates={
						startDate:toolbar.down('#dateRangePicker').startDate,
						endDate:toolbar.down('#dateRangePicker').endDate
				};
				dates.startDate = Ext.Date.format(dates.startDate,CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
				dates.endDate=Ext.Date.format(dates.endDate,CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
			}
			catch(e){
				dates={
						startDate:null,
						endDate:null
				};
			}
			
		}
	    if(view.xtype=='griddashlet' || view.xtype=='columnchartdashlet'){
	    	var store= view.getStore();
	    	var extraparams=this$.getParams();
	    	store.getProxy().extraParams = {
	    		startDate:dates.startDate,
	    		endDate:dates.endDate
	    	};
	    	store.load({params:extraparams,
	    		callback: function(rec, operation, success) {
	    			try{
		    			if(rec.length==0){
		    				this$.layout.setActiveItem(2);
		    			}
	    			}
	    			catch(e){
	    				this$.layout.setActiveItem(2);
	    			}
	    		}
	    	});
	    }else{
			if(view.xtype=='image'){
				this.layout.setActiveItem(0);
				var view1=this.layout.getActiveItem();
				var store= view1.getStore();
				var extraparams=this$.getParams();
				store.load({params:extraparams,
					callback: function(rec, operation, success) {
						if(rec.length==0){
							this$.layout.setActiveItem(2);
						}
					}
				});
			}
		}
	},
	defaults: {
		cls:'panelNoSpace',
    },
    
	items:[{
	    xtype:'griddashlet',
		model:'Academia.model.enquiry.EnquiryFollowupCorporateDashletModel',
		url : SERVERURL.ENQUIRY_CORPORATE_FOLLOWUP_DASHLET,
		addPagingToolbar : true,
		columns : [/*{
    		hidden: true,
    		dataIndex: 'id'
    	},*/ {
    		text : getEnquiryTranslation('ENQUIRY_NO'),
    		dataIndex : 'enqCode',
    		sortable : true,
    		//tpl: '<a>{EnquiryNumber}</a>',
    		renderer:function(value,meta,record){
    			if(!isNullOrEmpty(record)) {
				 value="<a href='#'>"+record.get('enqCode')+"</a>"; 
	             return value;
	        }
    		},
    		flex:0.1
    	}, {
    		text : getEnquiryTranslation('COMPANY_NAME'),
    		dataIndex : 'CompanyName',
    		sortable : true,
    		flex:0.1
    	},{
    		text : getEnquiryTranslation('ENQUIRY_CONTACT_PERSON'),
    		dataIndex : 'ContactPerson',
    		sortable : true,
    		flex:0.1
    	},{
    		text : getEnquiryTranslation('ENQUIRY_DATE'),
    		dataIndex : 'DateOfEnquiry',
    		sortable : true,
    		flex:0.1,
    		renderer : function(date) {
    			return dateRender(date);
    		}
    	}, {
    		text : getEnquiryTranslation('FOLLOW_UP_DATE'),
    		dataIndex : 'FollowUpDate',
    		sortable : true,
    		flex:0.1,
    		renderer : function(date) {
    			return dateRender(date);
    		}
    	}],
		listeners:{
			activate:function(portlet){
				var enquirycorporatefollowupdashlet=portlet.up('enquirycorporatefollowupdashlet');
				enquirycorporatefollowupdashlet.activeTab = 1;
//				enquirycorporatefollowupdashlet.addExportToPdf(enquirycorporatefollowupdashlet);
				enquirycorporatefollowupdashlet.addGraphViewButton(enquirycorporatefollowupdashlet);
				enquirycorporatefollowupdashlet.addExportToPdf(enquirycorporatefollowupdashlet,portlet);
				enquirycorporatefollowupdashlet.addExportToExcel(enquirycorporatefollowupdashlet,portlet);
				//portlet.doLayout();
			},
			deactivate:function(portlet){
					var enquirycorporatefollowupdashlet=portlet.up('enquirycorporatefollowupdashlet');
					enquirycorporatefollowupdashlet.removeGraphViewButton(enquirycorporatefollowupdashlet);
					enquirycorporatefollowupdashlet.removeExportToPdf();
					enquirycorporatefollowupdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				var $this=this;
				if(e.target.tagName == 'A'){
					var enquiryFollowGrid = cell.up('grid');
					var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
					var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
					trackEnquiryController.openEnquiryFromDashlet(0,0,enquiryFollowGrid,'Edit');
				}
				if(this.up('dashboardhomepage') == undefined){
					enquiryFollowGrid.up().up().up().close();
				}
			}
		}
	},{
		xtype:'columnchartdashlet',
		xAxesCategoryField :['date'],
		yAxesNumericField : ['count'],
		xAxesCategoryTitle :getEnquiryTranslation('DATE'),
		yAxesNumericTitle :getEnquiryTranslation('COUNT'),
		model:'Academia.model.enquiry.EnquiryFollowupDashletGraphModel',
		url : SERVERURL.ENQUIRY_CORPORATE_FOLLOWUP_DASHLET_GRAPH,
		listeners:{
			activate:function(portlet){
				var enquirycorporatefollowupdashlet=portlet.up('enquirycorporatefollowupdashlet');
				enquirycorporatefollowupdashlet.activeTab = 0;
				enquirycorporatefollowupdashlet.addGridViewButton(enquirycorporatefollowupdashlet);
				enquirycorporatefollowupdashlet.addExportToPng(enquirycorporatefollowupdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycorporatefollowupdashlet=portlet.up('enquirycorporatefollowupdashlet');
				enquirycorporatefollowupdashlet.removeGridViewButton(enquirycorporatefollowupdashlet);
				enquirycorporatefollowupdashlet.removeExportToPng();
			}
		}
	},{
		xtype: 'panel',
		width: '100%',
		height: '100%',
		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
		//src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
		listeners:{
			activate:function(portlet){
				var enquirycorporatefollowupdashlet=portlet.up('enquirycorporatefollowupdashlet');
				enquirycorporatefollowupdashlet.addExportToPdf(enquirycorporatefollowupdashlet);
				enquirycorporatefollowupdashlet.activeTab = 1;
				enquirycorporatefollowupdashlet.addGraphViewButton(enquirycorporatefollowupdashlet);
				enquirycorporatefollowupdashlet.addExportToPdf(enquirycorporatefollowupdashlet,portlet);
				enquirycorporatefollowupdashlet.addExportToExcel(enquirycorporatefollowupdashlet,portlet);
			},
			deactivate:function(portlet){
					var enquirycorporatefollowupdashlet=portlet.up('enquirycorporatefollowupdashlet');
					enquirycorporatefollowupdashlet.removeGraphViewButton(enquirycorporatefollowupdashlet);
					enquirycorporatefollowupdashlet.removeExportToPdf();
					enquirycorporatefollowupdashlet.removeExportToExcel();
			}
		}
	}]
});