Ext.define('Academia.view.dashboard.dashlets.HolidayCalendarDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.holidayCalendarDashlet',
	graphView:true,
	layout:'card',
	activeItem: 0, 
	autoScroll : false,
	cls:'StudentPersonalDashletCLS dashlet',
	loadDashlet : function() {
		var view= this.layout.getActiveItem();
		var calendardashletnew = this.down("#calendardashletnew");
		var fromDate = this.down("#fromDate");
		var toDate = this.down("#toDate");
		studentId = this.getCurrentlyLoggedInUserInfoForPortalDashlet().student.id;
		var store = calendardashletnew.getStore();
		store.getProxy().extraParams = {
			portalId: portalId,
			studentId:studentId,
			startDate:  null,
			endDate: null
		};
		store.removeAll();
		store.load();
		  Ext.Ajax.request({
	 			type : 'rest',
	            async: false,
	 			method : 'GET',
	 			params:{
	 				studentId:studentId,
	 			},
	 			url : SERVERURL.PATH_FIND_CURRENT_PERIOD_START_END_DATE_BY_STUDENT_ID,
	 			success: function(response, action) {
	 				dashboardHolyPeriodDate = Ext.decode(response.responseText); 
	 				if(dashboardHolyPeriodDate){
						fromDate.setValue(new Date(dashboardHolyPeriodDate.startDate));
						toDate.setValue(new Date(dashboardHolyPeriodDate.tillDate));
					}	
	 			}
	 		});
	},
	defaults: {
		cls:'panelNoSpace'
	},
	items:[{
		xtype:'panel',
		autoScroll:true,
		layout:'vbox',
		cls: 'mainPanelCls horizontalScrollingFixed',
		itemId:'pnlStudentDetails',
		//margin : 0,
		width:'100%',
		height:'100%',
		dockedItems: [{
	        xtype: 'toolbar',
	        dock: 'top',
	        height:80,
	        margin:'-20 0 0 5',
	        cls:'holidayToolbarCls',
	       items: [{
				xtype: 'form',
				//	border: true,
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign:'top',
						width:160
					},
					items: [{
						xtype: 'datefield',
						name: 'fromDate',
						itemId:'fromDate',
						vtype: 'daterange',
						allowBlank:false,
						labelAlign:'top',
						labelSeparator:' ',
						 endDateField : 'toDate',
						fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE'),
						//width:115,
					},{
						xtype: 'datefield',
						name: 'toDate',
						itemId:'toDate',
						margin:'0 0 0 10',
						allowBlank:false,
						vtype: 'daterange',
						labelAlign:'top',
						labelSeparator:' ',
						 startDateField : 'fromDate',
						fieldLabel: getCommonTranslation('TO_DATE'),
						//width:115,
					},{
						xtype: 'button',
						margin:'28 10 10 10',
						text: getCommonTranslation('APPLY'),
						itemId: 'applyFilterBtn',
						ui: 'CustomBtnCancel',
						formBind:true,
						height:28,
						scale: CONSTANTS.BUTTONSIZE	        				
					}]
				}]
	    }],
		items:[,{
			xtype: 'panel',
			width:'100%',
			autoScroll:false,
			items: [{
				xtype:'dataview',
				height:'100%',
				autoScroll:false,
				cls:'holidayCls',
				itemId:'calendardashletnew',
				store :Ext.create('Academia.store.dashboard.HolidayCalendarStore'),
				tpl:new Ext.XTemplate(
						'<tpl for=".">',
						'<div style="	width:100%;height:100%" class="gallery-thumb-wrap2">',
						'<div style="width:47%;height:54px;border:1px solid #ddd;border-radius: 5px;float:left;margin:6px">',
						'<div class="cal">',
						'<div class="date">{[this.getDate(values)]}</div> ',
						'<div class="month" style="background-color:{[this.getColorCode(values)]}">{[this.getMonth(values)]}, {[this.getYear(values)]}</div>',
						'</div>',
'<div style="width:{[this.checkDeailsDashlet(values)]};height:52px;float:right;margin-top: 4px;text-align: left;">',
						'<h4 class="holidayReasonCss" data-qtip="{[this.getReason(values)]}">{holidayReason}</h4>',
						'<p style="margin:0px;">{[this.getDay(values)]}</p>',
						'</div>',
						'</div>',
						

						'</div>',
						'</tpl>',
						{
							getDate:function(val){
								return new Date(val.fromDate).getDate();
							},
							getMonth:function(val){
								var monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
									  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
									];
								return monthNames[new Date(val.fromDate).getMonth()];
							},
							getYear:function(val){
								return new Date(val.fromDate).getFullYear().toString().substr(-2);
							},
							getColorCode:function(val){
								if([1,5,9].indexOf(new Date(val.fromDate).getMonth()+1) !== -1){
									return "#c4272b";
								}else if([2,6,10].indexOf(new Date(val.fromDate).getMonth()+1) !== -1){
									return "#FBBB04";
								}else if([3,7,11].indexOf(new Date(val.fromDate).getMonth()+1) !== -1){
									return "#273043";
								}else{
									return "#05b2c7";
								}
							},
							getDay:function(val){
								var daysName = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday",
									  "Saturday"];
								return daysName[new Date(val.fromDate).getDay()];;
							},
							getReason:function(val){
								return val.holidayReason;
							},
							checkDeailsDashlet:function(val){try{
								var domCmp = Ext.ComponentQuery.query('holidayCalendarDashlet');
								var flag=0;
								for(var count=0;count<domCmp.length;count++){
									if(domCmp[count] && domCmp[count].el && domCmp[count].el.dom){
										flag++;
									}
								}
								if(flag>1){
									return '90%';
			    	    		}else{
			    	    			return '75%';
			    	    		}
							}catch(e){
								console.log('error')
							}}
						}
				),
				itemSelector: 'div.gallery-thumb-wrap2',
				autoHeight:true,
				width: '100%',
				emptyText:getCommonTranslation('EMPTY_MESSAGE')
			}]
		}]
	}]
});
