/**
 * @author saket.puranik
 *  
 * This component is used for layout of Department tab
 */
Ext.define('Academia.view.department.Department', {
	extend : 'Ext.form.Panel',
	alias : 'widget.department',
	overflowY: 'scroll',
	/* requires  : [ 
	             'Academia.view.department.DepartmentGrid',
	             'Academia.view.department.SubDepartmentGrid'
	             ], */
	layout: {
		type: 'hbox'
	},

	items : [{ 
		style:{
	    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	    },
		xtype : 'departmentgrid',
		itemId : 'departmentgrid',
		flex:.6
	}
	,{ 
		xtype : 'subdepartmentgrid',
		itemId : 'subdepartmentgrid',
		flex:.4
	}
	],
	// BEGIN SCROLL-SAVING WORKAROUND CODE    
    onRender : function() {
        this.callParent(arguments);
        this.body.on('scroll', this.saveScroll, this);
    },
    
    afterComponentLayout : function() {
        this.callParent(arguments);
        this.restoreScroll();
    },
    
    saveScroll : function() {
        this.savedScroll = this.body.getScroll();
    },
    
    restoreScroll : function() {
        var savedScroll = this.savedScroll || {};  // empty obj for when no scroll has occurred before this method is executed
        this.body.scrollTo('top', savedScroll.top || 0);
    }
    // END SCROLL-SAVING WORKAROUND CODE
});
