/**
 * This view is used for Add document form
 * @author Vyabha.Thakur
 */
Ext.define('Academia.view.document.AddDocumentFormWindow', {
	//extend : 'Ext.form.Panel',
	extend: 'Ext.window.Window',
	alias : 'widget.adddocumentformwindow',
	title: getPersonModuleTranslation('DOCUMENTS_DETAILS'),
	autoScroll : false,
	plugins: "formlabelrequired",
	modal: true,
    height: '60%',
    items: [{
        xtype: 'form',
        itemId: 'documentFormWindowItemId',
	items : [ {
		xtype : 'hidden',
		itemId : 'document_hidden_field',
		name : 'id'
	}, {
		xtype : 'hidden',
		name : 'module'
	}, {
		xtype : 'hidden',
		name : 'entityId'
	}, {
		xtype : 'hidden',
		name : 'entityType'
	}, {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		items : [ {
			xtype : 'nestedJsonCombo',
			fieldLabel : getPersonModuleTranslation('DOCUMENTS_NAME'),
			store:'documentmanagement.DocumentMasterStore',
			name : 'documentType',
			displayField : 'value',
			valueField : 'id',
			allowBlank : false,
			hidden:false,
			itemId:'documentTypeCombo'
		},{
			xtype : 'nestedJsonCombo',
			fieldLabel : getPersonModuleTranslation('DOCUMENTS_TYPE'),
			store:'common.DocTypeStore',
			name : 'docType',
			displayField : 'value',
			valueField : 'name',
			allowBlank : false,
			itemId:'docType'
		}]
	}, {
		xtype : 'fieldcontainer',
		layout : 'fit',
		itemId : 'documentTypeContainer',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
	
		items : [{
			xtype : 'nestedJsonCombo',
			itemId : 'documentStatus',
			fieldLabel : getPersonModuleTranslation('STATUS'),
		    store: 'common.DocumentStatusCSMStore',
		    name: 'documentStatusCSM',
            valueField: 'id',
            displayField: 'value',
			readOnly: true,
			editable : false,
			allowBlank : false
		}]
  	}, 
	{
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		style: {
			marginTop: '17px',
		    marginLeft: '-2px'
		},
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SUBMIT'),
			itemId : 'documentFormSubmitButtonId',
			buttonAlign : 'right',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			buttonAlign : 'right',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			itemId : 'documentCancelButtonId',
			scale : CONSTANTS.BUTTONSIZE
		} ]
	} ]
    } ]
});
