Ext.define('Academia.view.document.DocumentPreviewWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.documentpreviewwindow',
    modal: true,
    autoScroll : true,
    resizable: false,
    draggable: false,
    cls: 'documentPreviewWinCls',
    initComponent: function() {
        this.callParent(arguments);
    },
	header:{
		titlePosition: 0,
		items:[{
			xtype: 'button',
			iconCls: 'download-icon',
			cls: 'download-btn',
			hidden: true,
			itemId: 'previewImgDownloadBtn',
			listeners:{
				click: function(btn){
					var win = btn.up('window');
					
					var documentRecord = win.documentRecord;
					var fileExtension = documentRecord.data.evidence.split('.').pop();

					var a = document.createElement('a');
					a.href = $('.documentPreviewPanelDivCls img')[0].src;
					a.download = win.title.replaceAll(" ","_")+"."+fileExtension;
					document.body.appendChild(a);
					a.click();
					document.body.removeChild(a);
				}
			}
		}]
	},
    items:[{
    	xtype: 'panel',
    	itemId: 'documentPreviewPanel',
    	bodyCls: 'documentPreviewPanelBodyCls',
    	width: '98%',
    	height: Ext.getBody().getHeight()-100,
    	style:{
    		minHeight: '90%',
    	},
    	html: '<div class="documentPreviewPanelDivCls"></div>',
    	listeners:{
    		afterrender: function(pnl){
    			pnl.setHeight('90%');
    		}
    	}
    }]
});