/**
 * This view is used for simple document form
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.document.SimpleDocumentForm', {
	extend : 'Ext.form.Panel',
	alias : 'widget.simpledocumentform',
	autoScroll : false,
	plugins: "formlabelrequired",
	defaults : {
		labelAlign:'top',
		width: 226
	},
	items : [{
		xtype : 'hidden',
		itemId : 'document_hidden_field',
		name : 'id'
	}, {
		xtype : 'hidden',
		name : 'module'
	}, {
		xtype : 'hidden',
		name : 'entityId'
	}, {
		xtype : 'hidden',
		name : 'entityType'
	}, {
		xtype : 'textfield',
		fieldLabel : getPersonModuleTranslation('DOCUMENTS_NAME'),
		itemId : 'documentNameField',
		name : 'name',
		allowBlank : false,
		maxLength: 50,
		vtype : 'NospaceAsInput'
	}, {
		xtype : 'filefield',
		ui : 'CustomBtnSubmit',
		fieldLabel : getPersonModuleTranslation('SELECT_FILE'),
		buttonText : getPersonModuleTranslation('UPLOAD'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		/*listeners:{
			change: function(field, val) { 
                var fileName = /^.*\.(exe)$/i;
                if(fileName.test(val)){
                	field.reset();
                	showWarningMessage(getCommonTranslation('UPLOAD_DOCUMENT'),getCommonTranslation('CANNOT_UPLOAD_EXE_FILE'));
                	return false;
                }
          }
		}*/
	},{
		xtype : 'textfield',
		fieldLabel : getPersonModuleTranslation('FILES_NAMES'),
		itemId : 'existingFile',
		name : 'files',
		allowBlank : true,
		readOnly : true,
		hidden: true
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		itemId:'containerIdForButtons',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SUBMIT'),
			itemId : 'documentFormSubmitButtonId',
			buttonAlign : 'right',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			buttonAlign : 'right',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			itemId : 'documentCancelButtonId',
			scale : CONSTANTS.BUTTONSIZE,
			handler : function(){
				if(Ext.isDefined(this.up('window'))){
					this.up('window').close();	
				}
			}

		} ]
	} ]
});
