/**
 */
Ext.define('Academia.view.documentmanagement.DocumentGroupMasterGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.documentgroupmastergrid',
    store: 'documentmanagement.DocumentGroupMasterGridStore',
    title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
    border: true,
    refreshStoreData:true,
    selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'documentmanagement.DocumentGroupMasterGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		 xtype: 'button',
		 itemId: 'bulkDocumentDownload',
		 text : getCommonTranslation('BULK_DOWNLOAD_DOC'),
		 tooltip :getCommonTranslation('BULK_DOWNLOAD_DOC')
		//formBind : true
	   }
	/*, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}*/],
    columns: [{
    	header: getCommonTranslation('GROUP_NAME'),
    	dataIndex: 'groupName',
    	flex: 1
    }, {
    	header: getCommonTranslation('DOCUMENT_STATUS'),
    	dataIndex: 'documentStatus',
    	flex: 1
    }, {
    	header: getCommonTranslation('SUBMISSION_LAST_DATE'),
    	dataIndex: 'dueOn',
    	flex: 1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header: getCommonTranslation('COMPLETED_ON'),
    	dataIndex: 'completedOn',
    	flex: 1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    },{
    	header: getCommonTranslation('STATUS'),
    	dataIndex: 'status',
    	flex: 1,
    	renderer: function(value, metadata, record) {
    		var msg  = 'Inactive';
    		if (value==true) {
    			msg = 'Active';
    		}
    		return msg;
    	}
    },{
    	header: getCommonTranslation('REQUESTED_TO'),
    	dataIndex: 'requestedTo',
    	flex: 1,
    	renderer: function(value, metadata, record) {
    		var msg = "";
    		if(record.get('isDocumentRequested')==true) {
    			msg = '<a href="#">' + "View" + '</a>';
    		}
    		return msg;
    	}
    }
    ]
});