/**
 * @author Pritam.Patil
 * This component is used for document List Grid
 */
Ext.define('Academia.view.documentmanagement.DocumentListGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.documentlistgrid',
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: true
    },
    headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'documentlistview':1
        }
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'

    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH

    }],
    columns: [ {
        header: getDocumentTranslation('DOCUMENT_CATEGORY'),
        dataIndex: 'configLevel',
        //align: 'center',
        sortable: true,
        flex: .2,
        renderer:function(value){
        	var msg;
        	if(!isNullOrEmpty(value)){
        		msg = getDocumentTranslation(value);
        	}else{
        		msg = value;
        	}
        	return msg;
        }
    }, {
        header: getDocumentTranslation('DOCUMENT_CODE'),
        dataIndex: 'typeCode',
        //align: 'center',
        sortable: true,
        flex: .2
    }, {
        header: getDocumentTranslation('DOCUMENT_NAME'),
        dataIndex: 'typeName',
        //align: 'center',
        sortable: true,
        flex: .2
    }, {
        header: getDocumentTranslation('WHETHER_AVAILABLE_FOR_ADHOC'),
        dataIndex: 'availableForAdhoc',
        //align: 'center',
        sortable: true,
        flex: .2,
        renderer: function(value){
	    	var msg;
	    	if(!isNullOrEmpty(value)){
	    		if(value){
	    			msg = getCommonTranslation('TRUE');
	    		}else{
	    			msg = getCommonTranslation('FALSE');
	    		}
	    	}else{
	    		msg = value;
	    	}
	    	return msg;
	    }
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.documentmanagement.DocumentTemplateStore');
    }
});