Ext.define('Academia.view.documentmanagement.DocumentRequestDownloadGrid', {
	extend:'Ext.grid.Panel',
	alias:'widget.documentrequestdownloadgrid',
	store:'documentmanagement.DocumentRequestShowGridStore',
	title: getCommonTranslation('LIST_OF_DOCUMENTS'),
	selType:'checkboxmodel',
	border:true,
	 dockedItems: [{
	        xtype: 'toolbar',
	        dock: 'bottom',
	        items: [{
	            xtype: 'custompagingtoolbar',
	            plugins: ['pagesize'],
	            store: 'documentmanagement.DocumentRequestShowGridStore',
	            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	            displayInfo: true
	        }]
	    }],
	    initComponent: function() {
	        //var grid = this;
	        //grid.addExportToolBarItems(grid);
	        this.callParent(arguments);
	    },
	tbar: ['->',{
		 xtype: 'button',
		 itemId: 'downloadAll',
		 text:getCommonTranslation('DOWNLOAD_ALL'),
		 tooltip :getCommonTranslation('DOWNLOAD_ALL')
    }],
	columns:[{
		header: getCommonTranslation('S_NO'),
		dataIndex:'documentIdCount',
		flex:0.5,
		
	},{
		header: getServiceRequestTranslation('DOCUMENTS'),
		dataIndex:'name',
		flex:0.5,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
					return '<a href=#>'+record.data.name+'<a>';
			}                        
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		flex:0.5,
		renderer:function(date) {
    		return dateRender(date);
    	}
	}]
}
);