/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.droolmaster.DroolRulesStructure', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.droolrulesstructure',
    plain: true,
    autoScroll: true,
    items : [{
		xtype:'panel',
	    items: [{
	    	title: getCommonTranslation('STD_MASTER_GRID'),
	    	itemId: 'droolRulesGridItemId',
	    	xtype: 'grid',
	    	border: true,
	    	autoScroll: false,
	    	frame:false,
	        layout: 'fit',
	        headerFix:{
	            headerFix: true,
	            portalIdsWithStructure: {
	                'droolrulesstructure':1
	            }
	        },
	    	columns: [{
				header : getCommonTranslation('DROOL_CODE'),
				dataIndex : 'droolCode',
				flex : 1,
			},{
				header : getCommonTranslation('DROOL_PRINT_NAME'),
				dataIndex : 'droolPrintName',
				flex : 1,
			},{
				header : getCommonTranslation('DROOL_FOR'),
				dataIndex : 'droolFor',
				flex : 1,
			},{
				header : getCommonTranslation('DESCRIPTION'),
				dataIndex : 'description',
				flex : 1,
			}],
	        columnLines: true,
	    	store: 'setup.droolrules.DroolMasterStore',
	        viewConfig: {
	            stripeRows: CONSTANTS.STRIPEROWS,
//	            emptyText: getCommonTranslation('SELECT_RECORD_TO_SHOW_DATASET'),
	            deferEmptyText: false
	        },
	        tbar: [{
	            xtype: 'button',
	            itemId: 'btnApplyToItemId',
	            tooltip : getExaminationTranslation('APPLY_TO'),
	            text: getExaminationTranslation('APPLY_TO'),
	            disabled: true
	        }],
	        dockedItems: [{
	            xtype: 'toolbar',
	            dock: 'bottom',
	            items: [{
	                xtype: 'custompagingtoolbar',
	                plugins: ['pagesize'],
	                store: 'setup.droolrules.DroolMasterStore',
	                emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	                displayInfo: true
	            }]
	        }]
	    }]
    }]
});