/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.enquiry.Reports.summaryreport.SummaryReportForm', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.summaryreportform',
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	// layout: 'vbox',
	items: [{
		xtype: 'form',
		width: '100%',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name:'enquiryNo',
				fieldLabel:getEnquiryTranslation('TRACK_ENQUIRY_NO'),
				itemId:'trackEnquiry_enquiryNo'
			},{
				xtype: 'customcombobox',
				name: 'enquiryType',
				fieldLabel:getEnquiryTranslation('ENQUIRY_TYPE_1'),
				store: 'enquiry.EnquiryTypeStore',
				valueField: 'id',
				displayField: 'enquiryTypeName',
				itemId: 'trackEnquiry_enquiryType',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false

			}]
		},{
        	xtype: 'fieldcontainer',
        	width: 'auto',
        	layout: 'hbox',
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
        	items : [{
				xtype : 'customcombobox',
				fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
				name : 'intakeYear',
				itemId : 'intakeYear',
				displayField:'value',
				valueField:'id',
				width:226,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.IntakeYearStore');
						combo.bindStore(store)
					}
				}
			},{
        		xtype: 'multiselectcombofield',
        		name: 'ownerUser',
        		itemId:'ownerUserId',
        		store: 'enquiry.reports.EnquiryOwnerUserStore',
				msgTarget: 'qtip',
				fieldLabel: getEnquiryTranslation('ENQUIRY_OWNER'),
				valueField: 'id',
				maxLength:100000,
				displayField: 'value',
				queryParam:'codeOrName',
    			minChars:3,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
//    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}' +
    					'</div>';
    				}
    			}
        	}]
        },{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
	            xtype: 'datefield',
	            fieldLabel: getEnquiryTranslation('FROM_DATE'),
	            name: 'FROM_DATE',
	          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
	            itemId: 'fromDate',
	            vtype: 'daterange',
	            endDateField: 'toDate',
	            maxValue : new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
	        }, {
	            xtype: 'datefield',
	            fieldLabel: getEnquiryTranslation('TO_DATE'),
	            name: 'TO_DATE',
	          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
	            itemId: 'toDate',
	            vtype: 'daterange',
	            startDateField: 'fromDate',
	            maxValue : new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
	            
	        }]

		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'programId',
				itemId:'programItemId',
				store:'common.ProgramByAcademyLocationStore',
				fieldLabel: getEnquiryTranslation('PROGRAM'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'programName',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
        		xtype: 'customcombobox',
        		name: 'batchId',
        		itemId:'batchItemId',
        	    store:'enquiry.BatchForEnquiryStore',
        	    fieldLabel:getEnquiryTranslation('BATCH'),
        		displayField:'value',
        		valueField:'id',
        		queryParam:'batchName',
        		minChars:3,
        		disabled:true,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				//allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
        	},{
        		xtype: 'customcombobox',
        		name: 'seatType',
        		itemId:'seatTypeItemId',
        	    store:'enquiry.SeatTypeForEnquiryStore',
        	    fieldLabel:getEnquiryTranslation('SEAT_TYPE'),
        		displayField:'value',
        		valueField:'id',
        		disabled:true,
        		queryParam:'seatTypeName',
        		minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				//allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
        	}]

		},{
			xtype: 'fieldcontainer',
			width: 'auto',

			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'trackenquiry_search',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				// buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});