/**
 * @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.view.enquiry.dashboard.EnquirySummaryGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.enquirysummarygrid',
	store : 'enquiry.dashboard.EnquirySummaryStore',
	border : true,
	cls:'enqgridsummarycls',
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask:false
	},
	tbar:['->',{
		xtype: 'splitbutton',
		itemId: 'btnExportToPDFJasper',
		cls: 'CustomToolbarBtnExport',
		iconCls:'export-pdf-icon',
		disabled:true,
		menu: [{
			text: 'Export Current Page',
			itemId: 'exportPDFCurrentPage'
		}]
	},{
		xtype: 'splitbutton',
		itemId: 'btnExportToExcelJasper',
		cls: 'CustomToolbarBtnExport',
		iconCls:'export-excel-icon',
		disabled:true,
		menu: [{
			text: 'Export Current Page',
			itemId: 'exportExcelCurrentPage'
		}]
	}],
	selModel: {
		selType: 'cellmodel'
	},
	features: [{
		id: 'group',
		ftype: 'groupingsummary',
		groupHeaderTpl: '{name}',
		hideGroupedHeader: false,
		enableGroupingMenu: true
	},{
		ftype: 'summary',
		dock: 'bottom'
	}],
	columns: [{
		text: getEnquiryTranslation('ACADEMY_LOCATION'),
		flex: 1,
		tdCls: 'task',
		sortable: true,
		align:'center',
		dataIndex: 'gradeName',
		hideable: false,
		variableRowHeight: true,
		field: {
			xtype: 'textfield'
		},
		summaryRenderer: function(value, summaryData, data) {
			var text = "Total";
			if(data.internalId.indexOf('summary') > 0){
				text = "Grand Total";
			}
			return text;
		}
	}, {
		header:getEnquiryTranslation('TOTAL_ENQUIRY'),
		flex: 1,
		sortable: true,
		dataIndex: 'totalLead',
		align:'center',
		summaryType: 'sum'
	}, {
		header: getEnquiryTranslation('OPEN_ENQUIRIES'),
		flex: 1,
		sortable: true,
		dataIndex: 'openLead',
		align:'center',
		summaryType: 'sum'
	},{
		header: getEnquiryTranslation('NOT_CONTACTECTED_ENQUIRY'),
		flex: 1,
		sortable: true,
		dataIndex: 'notContactedLead',
		align:'center',
		summaryType: 'sum'
	},{
		header: getEnquiryTranslation('CONTACTECTED_ENQUIRY'),
		flex: 1,
		sortable: true,
		dataIndex: 'contactedLead',
		align:'center',
		summaryType: 'sum'
	}, {
		header: getEnquiryTranslation('QUALIFIED_ENQUIRY'),
		flex: 1,
		sortable: true,
		dataIndex: 'qualifiedLead',
		align:'center',
		summaryType: 'sum'
	}, {
		header:getEnquiryTranslation('ENQUIRY_CLOSED_SUCCESSFULLY'),
		flex: 1,
		sortable: true,
		dataIndex: 'successfullyCloseLead',
		align:'center',
		summaryType: 'sum'
	}, {
		header: getEnquiryTranslation('ENQUIRY_CLOSED_UNSUCCESSFULLY'), 
		flex: 1.4,
		sortable: true,
		dataIndex: 'unSuccessfullyCloseLead',
		align:'center',
		summaryType: 'sum'
	}, {
		header: getEnquiryTranslation('NOT_INTERESTED_ENQUIRY'),
		flex: 1,
		sortable: true,
		dataIndex: 'notInterestedLead',
		align:'center',
		summaryType: 'sum'
	}, {
		header: getEnquiryTranslation('COULD_NOT_CONTACT_LEADS'),
		flex: 1,
		sortable: true,
		dataIndex: 'couldnNotContactLead',
		align:'center',
		summaryType: 'sum'
	}, {
		header: getEnquiryTranslation('WEEKLY_MOVMENT_TOTAL_LEADS'),
		flex: 1,
		sortable: true,
		dataIndex: 'weeklyMovmentLeads',
		align:'center',
		summaryType: 'sum',
		field: {
			xtype: 'numberfield'
		}
	}, {
		header: getEnquiryTranslation('TARGET_TOTAL_DATABASE_ENQUIRY'),
		flex: 1,
		sortable: true,
		dataIndex: 'targetTotalDatabaseLeads',
		align:'center',
		summaryType: 'sum',
		field: {
			xtype: 'numberfield'
		}
	}, {
		header: getEnquiryTranslation('PERCENTAGE_TO_TARGET_TOTAL_LEADS'),
		flex: 1,
		sortable: true,
		dataIndex: 'percentageToAllLeads',
		align:'center',
		renderer: function(val, rec,e){
			if(!isNullOrEmpty(val)){
				return val.toFixed(2) + '%';
			} else {
				return '';
			}

		},
		summaryRenderer: function(value, summaryData, data) {
			var totalLead = data.get('totalLead');
			var targetTotalDatabaseLeads = data.get('targetTotalDatabaseLeads');
			var percentageToAllLeads = null;
			if(targetTotalDatabaseLeads>0){
				percentageToAllLeads = (totalLead/targetTotalDatabaseLeads)*100;
			} 
			if(!isNullOrEmpty(percentageToAllLeads) && !isNaN(percentageToAllLeads)){
				return percentageToAllLeads.toFixed(2) + "%" ;
			} else {
				return '';
			}
		}
	},{
		header: getEnquiryTranslation('YOY_VARIANCE_ENQUIRY_TARGET_TO_DATE'),
		flex: 1,
		sortable: true,
		dataIndex: 'yoyVarianceTotalLead',
		align:'center',
		//summaryType:'sum',
		renderer: function(val, rec,e){
			if(!isNullOrEmpty(val)){
				return val.toFixed(2) + '%';
			} else {
				return '';
			}
		},
		summaryRenderer: function(value, summaryData, data) {
			var previousYearLead = 0;
			var totalLead = data.get('totalLead');
			var yoyVarianceTotalLead = "";
			if(data.internalId.indexOf('summary') > 0){
				var range = this.getStore().getRange();
				range.forEach(function(obj){
					previousYearLead = previousYearLead+obj.get('previousYearLead');
				});
			} else {
				previousYearLead = data.get('previousYearLead');
			}
			if(!isNullOrEmpty(previousYearLead) && previousYearLead>0){
				yoyVarianceTotalLead = ((totalLead-previousYearLead)/previousYearLead)*100;
				return yoyVarianceTotalLead.toFixed(2) + "%" ;
			} else {
				return '';
			}

		}
	},{
		header: getEnquiryTranslation('PREVIOUSYEARLEAD'),
		flex: 1,
		sortable: true,
		hidden:true,
		dataIndex: 'previousYearLead',
		align:'center',
		summaryType: 'sum',
		field: {
			xtype: 'numberfield'
		}
	}]
});