/**
 *  Ravi Choudhary
 */
Ext.define('Academia.view.enquiry.enquirydetail.EnquiryDetailFormRevamp', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity: CONSTANTS.ENQUIRY_RAISE_CF_DATA,
	columns: 1,
	plugins: "formlabelrequired",
	alias: 'widget.enquirydetailformrevamp',
	autoScroll: false,
	frame: false,
	border:false,
	method: 'POST',
	standardSubmit: false,
	layout: 'anchor',
	/*layout:{
			   		type:'table',
			   		columns:2		
			   	},*/
	defaults: {
		width: 226,
		labelAlign: 'top',
		tdAttrs: {
			style: 'padding: 5px;'
		}
	},
	items: [{
		xtype: 'hidden',
		id: 'enquiryDetail_id',
		name: 'id'
	}, {
		xtype: 'hidden',
		id: 'enquiryDetail_addressId',
		name: 'addressId'
	}, {
		xtype: 'hidden',
		id: 'enquiryDetail_enquiryAddressId',
		name: 'enquiryAddressId'
	}, {
		xtype: 'hidden',
		name: 'status'
	}, {
		xtype: 'hidden',
		id: 'enquiryDetail_userId',
		name: 'userId'
	}, {
		xtype: 'hidden',
		name: 'enqIntermediateTypeId'
	}, {
		xtype: 'hidden',
		name: 'enqIntermediateType'
	},{
		xtype:'hidden',
		itemId:'setStudentDetailModel',
		name:'setStudentDetailModel'
	}, {

		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'enquiryType',
			fieldLabel:getEnquiryTranslation('ENQUIRY_TYPE'),
			store: 'enquiry.EnquiryTypeCounsellingStore',
			valueField: 'id',
			displayField: 'enquiryTypeName',
			itemId: 'enquiryDetail_enquiryType',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'registeredByType',
			id: 'enquiryDetail_registeredByType',
			//store: 'enquiry.EnquiryTypeStore',
			store: 'enquiry.EnquiryRegisteredBy',
			fieldLabel: getEnquiryTranslation('ENQUIRED_BY'),
			editable: false,
			valueField: 'id',
			displayField: 'value',
			itemId: 'enquiryTypeCombo',
			allowBlank:true
		}, {

			 xtype: 'datefield',
			name: 'enquiryDate',
			id: 'enquiryDetail_enquiryDate',
			readOnly: true,
			fieldLabel: getEnquiryTranslation('ENQUIRY_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype : 'customcombobox',
			name : 'enqIntakeYear',
			itemId : 'enqIntakeYearItemId',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStore'),
			valueField : 'id',
			displayField : 'value',
			editable : false,
			hidden:true
		}]

	},{

		xtype: 'fieldcontainer',
		itemId: 'enquiryDetailNamePanel',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top',
		},
		items: [{        	
			xtype: 'customcombobox',
			name: 'enquiryDetailSalutation',
			fieldLabel:getCommonTranslation('TITLE'),
			store: 'common.SalutationStore',
			queryMode: 'remote',
			valueField: 'id',
			displayField: 'salutationName',
			allowBlank:false,
			id:'enqDetailSalutaion',
			editable: false
		},{
			xtype: 'textfield',
			name: 'firstName',
			id: 'enquiryDetail_firstName',
			allowBlank: false,
			fieldLabel: getEnquiryTranslation('PARENT_FIRST_NAME'),
			maxLength:100,
			enforceMaxLength : true
		}, {
			xtype: 'textfield',
			name: 'middleName',
			id: 'enquiryDetail_middleName',
			fieldLabel: getEnquiryTranslation('PARENT_MIDDLE_NAME'),
			maxLength:53,
			enforceMaxLength : true
		}]
	}, {
		xtype: 'fieldcontainer',
		width: '100%',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{

			xtype: 'textfield',
			name: 'lastName',
			id: 'enquiryDetail_lastName',
			allowBlank:false,
			fieldLabel: getEnquiryTranslation('PARENT_LAST_NAME'),
			maxLength:100,	
			enforceMaxLength : true
		},{
			xtype: 'textfield',
			name: 'primaryeEmailId',
			id: 'enquiryDetail_primaryeEmailId',
			vtype: 'email',
			fieldLabel: getEnquiryTranslation('PARENT_EMAIL'),
			maxLength:100,
			enforceMaxLength : true,
			allowBlank:false
		},{
			xtype:'fieldcontainer',
			labelSeparator : '',
			fieldLabel: getEnquiryTranslation('PARENT_ADDRESS_MOBILE_NO')+':<span class="required" style="color:red"> *</span>',
			itemId:'parentAddressMobileNo',
			name: 'parentAddressMobileNo',
			layout:'hbox',
			labelAlign:'top',
			items:[{
				xtype: 'customcombobox',
				id: 'enquiryDetail_cellCountrycode',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: 'common.CountryStore',
				triggerAction: 'all',
				name: 'cellCountrycode',
				editable: false,
				width: 80,
				emptyText: getCommonTranslation('CODE'),
				allowBlank:false
			}, {
				xtype: 'numberfield',
				name: 'cellNo',
				id: 'enquiryDetail_cellNumber',
				minLength: 0,
				maxLength: 15,
				width: 135,
				emptyText: 'Mobile Number',
				hideTrigger: true,
				allowBlank:false
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: 'hbox',
		
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype:'fieldcontainer',
			fieldLabel: getEnquiryTranslation('ALTERNATE_NUMBER'),
			layout:'hbox',
			labelAlign:'top',
			itemId:'enquiryDetail_alternateCellNumber',				
			items:[{
				xtype: 'customcombobox',
				id: 'enquiryDetail_alternateCellCountrycode',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: 'common.CountryStore',
				triggerAction: 'all',
				name: 'alternateCellCountrycode',
				editable: false,
				width: 80,
			}, {
				xtype: 'numberfield',
				name: 'alternateCellNo',
				id: 'enquiryDetail_alternateCellNumber',
				itemId:'enquiryDetail_alternateCellNumberField',
				minLength: 0,
				maxLength: 15,
				width: 135,
				emptyText: 'Mobile Number',
				hideTrigger: true,
			}]
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'country',
			id: 'enquiryDetail_country',
			fieldLabel: getCommonTranslation('ADDRESS_COUNTRY'),
			store: 'common.CountryStore',
			valueField: 'id',
			displayField: 'countryName',
			itemId: 'country',
			editable:false,
			forceSelection:true,
			allowBlank: false

		}, {
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('COUNTRY_REGION'),
			itemId : 'genericFieldId1',
			id : 'genericFieldId1',
			store:'organization.CountryRegionStore',
			valueField : 'id',
			displayField : 'countryRegionName',
			name : 'parentCountryRegion',
			editable : false,
			valueNotFoundText:"",        		        						
			forceSelection :true,
			allowBlank: false,
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('ADDRESS_CITY'),
			id: 'enquiryDetail_city',
			name: 'city',
			editable: false,
			allowBlank: false,
			itemId: 'city',
			store: 'organization.CityByCountryRegion',
			valueField: 'id',
//			displayField: 'cityName'
			displayField: 'value'
		}, {
			xtype: 'hidden',
			id: 'enquiryDetail_parentCountryRegion',
			name: 'parentCountryRegionId'
		}, {
			xtype: 'hidden',
			id: 'enquiryDetail_countryRegion',
			name: 'countryRegionId'
		}, {
			xtype: 'hidden',
			id: 'enquiryDetail_versionId',
			name: 'version'
		}]
	},{
		xtype:'displayfield',
		fieldLabel:'<b class="menu-title" style="color:#666666;">'+getEnquiryTranslation('ENQUIRY_STUDENT_MORE_DETAILS')+'</b>',
		name:'studentMoreDetail',
		style: {
			textDecoration: "underline"
		}
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign:'top',
			regex: /[a-zA-Z0-9]+/
		},
		items:[{
				xtype: 'datefield',
				name: 'studentDateOfBirth',
				id:'enQStudentDetails_studentDateOfBirth',
				itemId:'enQStudentDetails_studentDateOfBirth',
				maxValue : new Date(),
				fieldLabel:getEnquiryTranslation('DATE_OF_BIRTH'),
				//--submitFormat: 'd-m-Y',// CONSTANTS.DATE_FORMAT,
	            	listeners: {
	            		render: function(field) {
	            			return dateFormatRender(field);
	            		},
	                	change : function(date){
	                		var calcAge = date.up('form').getForm().findField('ageAsOnBirthDate');
	                       // console.log('calcAge....',calcAge);
	                         var today = new Date();
	                         var birthDate = new Date(date.lastValue);
	                         var age = today.getFullYear() - birthDate.getFullYear();
	                         var dobMonth = birthDate.getMonth();
	                         var tillDtMonth = today.getMonth();
	                         var month;
	                         if(tillDtMonth<dobMonth){
	                        	 age--;
	                        	 month=12-(dobMonth-tillDtMonth);
	                         }else if (tillDtMonth>dobMonth){
	                        	 month=tillDtMonth-dobMonth;
	                         }else{
	                        	 month=0;
	                         }
	                        	 calcAge.setValue(age + ' Year'+' '+ month +' Months');
	                	}
	                }
			},{
				xtype: 'textfield',
				fieldLabel: getEnquiryTranslation('PRESENT_AGE'),
				itemId: 'enQAgeAsOnBirthDate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
				name: 'ageAsOnBirthDate',
				editable: false,
				readOnly:true,
				disabled:true,
				
			},{  
				xtype: 'customcombobox',
				name: 'gender',
				id:'enQStudentDetails_gender',
				itemId:'enQStudentDetails_gender',
				store: 'common.GenderTypeStore',
				fieldLabel: getEnquiryTranslation('GENDER'),
				editable: false,
				valueField: 'id',
				displayField: 'value',
				//allowBlank: false
		},]

	},{
    	xtype: 'fieldcontainer',
    	width: '100%',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		width: 226,
    		labelAlign:'top'
    	},
    	items:[{
    		xtype : 'radiogroup',
    		fieldLabel : getCommonTranslation('IS_ENQ_STUDENT_SA_CITIZEN'),
    		itemId: 'enQStdIsLearnerSACitizenItemId',
    		name: 'stdIsLearnerSACitizenItemId',
    		defaults: {
    			flex: 1
    		},
    		layout: 'hbox',
    		items:[{ 
    			boxLabel: getCommonTranslation('YES'), 
    			name: 'isLearnerSACitizen', 
    			inputValue: true,
    			checked:true
    		},{ 
    			boxLabel: getCommonTranslation('NO'), 
    			name: 'isLearnerSACitizen', 
    			inputValue: false
    		}]
    	},{
			xtype: 'textfield',
			name: 'nationalId',
			itemId:'enQStdNationalId',
			fieldLabel: getEnquiryTranslation('NATIONAL_ID_NUMBER'),
			maxLength: 50,
		 //   vtype: 'NoSpecialCharactersWithNumberWithoutSpaceAsInput'
		}]
    
	},{
		xtype:'displayfield',
		fieldLabel:'<b class="menu-title" style="color:#666666;" >'+getEnquiryTranslation('PARENTS_DETAILS')+'</b>',
		name:'parentDetail',
		style: {
			textDecoration: "underline"
		}
	},{
		xtype: 'fieldcontainer',
		itemId : 'enQFatherDetailsContainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign:'top',
			 regex: /[a-zA-Z0-9]+/
		},
		items:[{        	
			xtype: 'customcombobox',
			name: 'fatherSalutationId',
			itemId: 'fatherSalutationId',
			fieldLabel:getEnquiryTranslation('SALUTATION'),
			store: 'common.SalutationStore',
			queryMode: 'local',
			valueField: 'id',
			displayField: 'salutationName',
			width: 80,
			id:'enQStudentDetails_father_salutation',
			editable: false
		},{
			xtype: 'textfield',
			name: 'fatherFirstName',
			itemId:'enQStudentDetails_fatherFirstName',
			fieldLabel: getEnquiryTranslation('FATHER_FIRST_NAME'),
			//allowBlank: false,
			maxLength:35,
			enforceMaxLength : true
		},{        	   
			xtype: 'textfield',
			name: 'fatherLastName',
			itemId:'enQStudentDetails_fatherLastName',
			fieldLabel: getEnquiryTranslation('FATHER_LAST_NAME'),
			//allowBlank: false,
			maxLength:35,
			enforceMaxLength : true
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign:'top',
			regex: /[a-zA-Z0-9]+/
		},
		items:[{
			xtype: 'textfield',
			fieldLabel: getAdmissionTranslation('EMAIL_ADDRESS'),
			name: 'fatherEmailId',
			vtype: 'email',
			itemId: 'enQStdEmailId',
			maxLength: '100'
		},{
			xtype: 'fieldcontainer',
			itemId : 'enQMobileNoFldItemId',
			fieldLabel: getCommonTranslation('MOBILE_NUMBER'),
			//allowBlank: false,
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'fatherPhoneCountryCode',
				itemId: 'enQStdCountryCodeItemId',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: 'common.CountryStore',
				triggerAction: 'all',
				//editable: false,
				forceSelection: true,
				minChars: 1,
				width: 63,
				labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
			}, {
				xtype: 'numberfield',
				name: 'fatherPhoneNo',
				itemId: 'enQStdMobileNumberItemId',
				minLength: 0,
				maxLength: 15,
				enforceMaxLength: true,
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential: false,
				width: 153,
				labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
			}]
		}]
	},{
		xtype:'displayfield',
		fieldLabel:'<b class="menu-title" style="color:#666666;">'+getEnquiryTranslation('SIBLLINGS_DETAILS')+'</b>',
		name:'sibllingsDetails',
		style: {
			textDecoration: "underline"
		}
	},{
		xtype: 'radiogroup',
		//width: 300,
		defaults: {
            flex: 1
        },
        layout: 'hbox',
		name: 'organizationsiblling',
		itemId:'enQSD_radioBtn_orgSiblling',
		id:'enQStudentDetailForm_whetherSiblingStudying_ID',
		fieldLabel: getEnquiryTranslation('SIBLLING_STUDYING_ORGANIZATION'),
		items:[{ boxLabel: getCommonTranslation('YES'), name: 'whetherSiblingStudying', inputValue: true},
		       { boxLabel: getCommonTranslation('NO'), name: 'whetherSiblingStudying', inputValue: false,checked:true}
		]
	},{	
		xtype: 'fieldcontainer',
		itemId:'siblingDetailsComponent',
		hidden:true,
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			xtype: 'customcombobox',
			labelAlign:'top'
		},
		items:[{
			id:'enQStudentDetails_addmissionIdofsiblling1',
			itemId:'enQStudentDetails_addmissionIdofsiblling1',
			name: 'sibilingUser1',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			fieldLabel:getEnquiryTranslation('USER_ID_OF_SIBLLING_1'),
			store: 'enquiry.ReferredIdStore2',
			queryParam:'name',
			displayField: 'valueCode',
			valueField: 'id',
			queryParam:'name',
			typeAhead:false,
			forceSelection:true,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
			id:'enQStudentDetails_addmissionIdofsiblling2',
			itemId:'enQStudentDetails_addmissionIdofsiblling2',
			name: 'sibilingUser2',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			fieldLabel:getEnquiryTranslation('USER_ID_OF_SIBLLING_2'),
			store: 'enquiry.ReferredIdStore3',
			queryParam:'name',
			displayField: 'valueCode',
			valueField: 'id',
			queryParam:'name',
			typeAhead:false,
			forceSelection:true,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
			
		},{
			id:'enQStudentDetails_addmissionIdofsiblling3',
			itemId:'enQStudentDetails_addmissionIdofsiblling3',
			name: 'sibilingUser3',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			fieldLabel:getEnquiryTranslation('USER_ID_OF_SIBLLING_3'),
			store: 'enquiry.ReferredIdStore4',
			queryParam:'name',
			valueField: 'id',
			displayField: 'valueCode',
		    queryParam:'name',
		    typeAhead:false,
			forceSelection:true,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		
		}]  

	},{
		xtype:'displayfield',
		value:'<b class="menu-title">'+getEnquiryTranslation('ADDITIONAL_INFORMATION')+'</b>',
		style: {
			textDecoration: "underline"
		}
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [ {
			xtype: 'customcombobox',
			name: 'campaignNew',
			itemId: 'enquiryCampaign',
			fieldLabel: getCommonTranslation("BRAND_CAMPAIGN_NAME"),
			//store: 'campaignnew.CampaignOpenComboStore',
			store: 'campaignnew.CampaignNameFilterStore',
			queryParam:'campaignName',
			valueField: 'id',
			displayField: 'value',
			width : 462,
			maxLength: 226,
			forceSelection :true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		  },
		 {
			xtype: 'textfield',
			name: 'campaignType',
			itemId:'campaignType',
			fieldLabel: getCommonTranslation('CAMPAIGN_TYPE'),
			readOnly: true
		}],
	},
		{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'textfield',
			name: 'presentationType',
			itemId:'presentationType',
			fieldLabel: getCommonTranslation('PRESENTATION_TYPE'),
			readOnly: true
		},{
			xtype: 'customcombobox',
			name:'campaign',
			id: 'enquiryDetail_campaign',
//			store:'campaign.CampaignCodeOrNameSmartSearch',
			store: Ext.create('Academia.store.campaign.CampaignCodeOrNameSmartSearch'),
			fieldLabel: getEnquiryTranslation('ENQUIRY_CAMPAIGN_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:true,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}
		}]

	}, {
		 xtype:'fieldcontainer',
		 layout:'hbox',
		 width:'100%',
		 defaults: {
			 width: 226,
			 labelAlign: 'top'
		 },
		 items:[ {
				xtype: 'customcombobox',
				name: 'educationDepartment',
				itemId: 'educationDepartmentItemId',
				store: 'enquiry.EducationDepartmentStore',
				fieldLabel: getEnquiryTranslation('EDUCATION_DEPARTMENT'),
				valueField: 'id',
				displayField: 'value',
				allowBlank: true,
				forceSelection: true,
				editable: false
			},{
				xtype: 'customcombobox',
				name: 'campaignSchool',
				itemId: 'campaignSchool',
				fieldLabel: getCommonTranslation("SCHOOL"),
				valueField: 'schoolId',
				displayField: 'schoolName',
				store: Ext.create('Academia.store.campaignnew.CampaignSchoolNameStore'),
				queryParam:'schoolName',
				minChars:3,
				allowBlank:true,
				forceSelection :true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								picker.width = picker.up('combobox').getSize().width;
							}
						},
				loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
			},{
				 xtype: 'customcombobox',
				 name: 'schoolPriorityNew',
				 itemId:'schoolPriorityNew',
				 fieldLabel: getCommonTranslation('SCHOOL_PRIORITY'),
				 store: Ext.create('Academia.store.campaignnew.AllSchoolPriorityStore'),
				 valueField: 'id',
				 displayField: 'value',
				 typeAhead:true,
				 forceSelection:true,
				 allowBlank:true,
				 editable: false,
				 disabled:true,
				 hidden:true
			 }, {
				xtype: 'textfield',
				name: 'schoolPriority',
				itemId:'schoolPriority',
				fieldLabel: getCommonTranslation('BRAND_CAMP_SCHOOL_PRIORITY'),
				readOnly: true
			}, 
			{
				xtype: 'multiselectcombofield',
				name: 'enquiryMultipleMode',
				itemId:'enquiryModeItemId',
				fieldLabel: getEnquiryTranslation('MODE_OF_ENQUIRY'),
				store:'enquiry.EnquiryModeStore',
				cls:'commonAutoHeightMultiselectField',
	    		valueField: 'id',
	    		displayField: 'value' 
			}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{	
			xtype: 'customcombobox',
			id: 'enquiryDetail_enquirySource',
			name: 'sourceCode',
			fieldLabel: getEnquiryTranslation('SOURCE'),
			store: 'enquiry.EnquirySourceStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank:false,
			editable: false
		}, {
			xtype: 'textfield',
			name: 'enquirySourceOther',
			id: 'enquiryDetail_enquirySourceOther',
			fieldLabel: getEnquiryTranslation('OTHER_SOURCE'),
			maxLength:53,
			enforceMaxLength : true,
			hidden: true
		},{
			xtype      : 'radiogroup',
			fieldLabel : getCommonTranslation('COMPANY_SPONSORED'),
			itemId: 'isCompanySponsored',
			name: 'isCompanySponsored',
			defaults: {
				flex: 1
			},
			layout: 'hbox',
			items:[{ 
				boxLabel: getCommonTranslation('YES'), 
				name: 'whetherCompanySponsored', 
				inputValue: true,
				checked:true
			},{ 
				boxLabel: getCommonTranslation('NO'), 
				name: 'whetherCompanySponsored', 
				inputValue: false
			}]
		},{
			xtype: 'customcombobox',
			name: 'referredType',
			//allowBlank:false,
			store: 'enquiry.ReferredTypeStore',
			fieldLabel: getEnquiryTranslation('REFFERED_BY'),
			valueField: 'id',
			displayField: 'value',
			itemId: 'referredType',
			typeAhead:true,
			editable:false,
			forceSelection:true
		},
		{
			xtype: 'customcombobox',
			name: 'referrerName',
			itemId:'referrerName',
			fieldLabel: getEnquiryTranslation('REFERRER_NAME'),
			hidden:false,
			store: 'enquiry.ReferredIdStore',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			editable:true,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			allowBlank:false,
			hidden:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		}, {
	 		   xtype: 'textfield',
			   name: 'refUserName',
			   fieldLabel: getCommonTranslation('REFERRER_NAME'),
			   maxLength: 255,
			   allowBlank:false,
			   hidden:true,
			   disabled:true
		   }]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
            name: 'programCategory',
            itemId:'programCategoryId',
            fieldLabel: getCommonTranslation('ENQUIRY_PROGRAM_CATEGORY'),
            displayField:'value',
            valueField:'id',
            store:Ext.create('Academia.store.program.ProgramCategoryStore'),
            forceSelection:true
		}
	]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
//			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype      : 'radiogroup',
			fieldLabel : getCommonTranslation('RECEIVE_AUTOMATIC_COMMUNICATION'),
			//readOnly: true,
			disabled: false,
			itemId: 'receiveCommunicationItemId',
			name: 'receiveCommunication',
			defaults: {
				flex: 1
			},
			layout: 'hbox',
			items:[{ 
				boxLabel: getCommonTranslation('YES'), 
				name: 'whetherReceiveCommunication', 
				inputValue: true,
				checked:true
			},{ 
				boxLabel: getCommonTranslation('NO'), 
				name: 'whetherReceiveCommunication', 
				inputValue: false
			}]
		
		}]
	
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '70%',
		defaults: {
//			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'textarea',
			width:'40%',
			name: 'remark',
			id: 'enquiryDetail_remark',
			allowBlank: false,
			fieldLabel: getEnquiryTranslation('COMMENTS'),
			maxLength:3000,	
		}]
	
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign:'top'
		},
		items:[{
			xtype: 'textfield',
			name: 'enqExtSystemRefFirst',
			itemId:'enqExtSystemRefFirst',
			fieldLabel: getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_1'),
			maxLength:50,
			enforceMaxLength : true,
			hidden:true
		},{
			xtype: 'textfield',
			name: 'enqExtSystemRefSecond',
			itemId:'enqExtSystemRefSecond',
			fieldLabel: getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_2'),
			maxLength:50,
			enforceMaxLength : true,
			hidden:true
		},{
			xtype: 'textfield',
			name: 'enqExtSystemRefThird',
			itemId:'enqExtSystemRefThird',
			fieldLabel: getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_3'),
			maxLength:50,
			enforceMaxLength : true,
			hidden:true 
		}]

	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '70%',
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'finance',
			itemId: 'finance',
			store:'enquiry.FinanceModeStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			forceSelection: true,
			editable: false,
			typeAhead : false,
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			},
			fieldLabel: getCommonTranslation('FINANCE')
		}]
	
	}, {
		border : false,
		layout : {
			type : 'hbox',
			width : '100%'
		},
		style:{
			marginLeft:'0px'
		},
		items: [{
			xtype: 'button',
			name:'enquirydetail_SubmitButtonId',
			action: 'Submit',
			id: 'enquirydetail_SubmitButtonId',
			formBind: true,
			text: getCommonTranslation('SAVE'),
			itemId: 'enquirydetail_SubmitButtonId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			ui: 'CustomBtnCancel',
			itemId: 'enquirydetail_EditButtonId',
			scale: CONSTANTS.BUTTONSIZE

		}]
	}]
});