/**
 * Rajkumar
 */

Ext.define('Academia.view.enquiry.followup.ClosureFollowUpGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias : 'widget.closurefollowupgrid',
    store : 'enquiry.closure.ClosureStore',
    title: getEnquiryTranslation('LIST_OF_CLOSURE_FOLLOWUP_DETAILS'),
    border: true,
    id:'closurefollowup_grid',
    autoScroll: false,
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [ {
	xtype : 'toolbar',
	dock : 'bottom',
	items : [ {
		xtype: 'custompagingtoolbar',
        plugins:['pagesize'],
        emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
	    store:'enquiry.closure.ClosureStore',
	    displayInfo : true
	}]
    }],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar : [{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}],
    columns : [{
    	header : getEnquiryTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex : 1
	},{
		header : getEnquiryTranslation('LOCATION'),
		dataIndex : 'locationName'
	},{
		header : getEnquiryTranslation('PROGRAMS_ENQUIREY_FOR_GRID'),
		dataIndex : 'program',
		flex : 1,
		renderer : function(value){
			return value.value;
		}
	},{
		header : getEnquiryTranslation('ACADEMIC_BATCH'),
		dataIndex:'batch',
		flex : 1,
		renderer : function(value){
			return value.value;
		}
	},{
		header : getEnquiryTranslation('SEAT_TYPE'),
		dataIndex : 'seatType',
		flex : 1,
		renderer : function(value){
			if(value!=null){
			    return value.value;
			}else{
				return '';
			}
		}
	},{
		header : getEnquiryTranslation('RESERVATION_CATEGORY_GRID'),
		dataIndex : 'reservationCategoryCode',
		flex : 1
	},{
		header : getEnquiryTranslation('CLOSURE_DATE'),
		dataIndex : 'closureDate',
		flex : 1,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getEnquiryTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1 
         }]

});