/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.eventlevelremark.EventLevelRemarkFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.eventlevelremarkfilter',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'remarkCodeOrName',
            fieldLabel: getExaminationTranslation('REMARK_CODE_OR_NAME'),
            itemId: 'remarkCodeOrName',
            displayField: 'value',
            valueField: 'id',
            store: 'eventlevelremark.EventLevelRemarkComboStore',
            minChars: 3,
            queryParam: 'name',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            enableKeyEvents: 'true',
            forceSelection: true,
            typeAhead: false,
            hideTrigger: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'status',
            fieldLabel: getCommonTranslation('STATUS'),
            itemId: 'statusItemId',
            displayField: 'name',
            valueField: 'id',
            value: 'ALL',
            editable: false,
            store: {
                fields: ['id', 'name'],
                data: [{
                	id: 'ALL',
                	name: 'All'
                }, {
                    id: 'ACTIVE',
                    name: 'Active'
                }, {
                    id: 'INACTIVE',
                    name: 'Inactive'
                }]
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'quickSearchId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetBtn',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});