/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.eventmeetingminutes.EMMForwardedTaskHistoryGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.emmforwardedtaskhistorygrid',
    store: 'eventmeetingminutes.EMMForwardedTaskHistoryStore',
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [{
        //width: '30%',
        flex: .4,
        header: getServiceRequestTranslation('FD_DATE'),
        dataIndex: 'forwardedDate',
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getServiceRequestTranslation('EMM_MINUTE_SUBJECT'),
        dataIndex: 'minuteSubject',
        flex: .5,
        sortable: true,
    }, {
        //width: '70%',
        header: getServiceRequestTranslation('STATUS'),
        dataIndex: 'status',
        flex: 1,
        renderer: function(val) {
            var colorValue = '';
            if (val == 'PENDING') {
                colorValue = getServiceRequestTranslation('EMM_FORWARDED_MINUTE_HISTORY_GRID_MESSAGE_PENDING_COMPLETED') + "<span style = 'color:#cc0000;'>" + getCommonTranslation(val) + "</span>";
            } else if (val == 'COMPLETED') {
                colorValue = getServiceRequestTranslation('EMM_FORWARDED_MINUTE_HISTORY_GRID_MESSAGE_PENDING_COMPLETED') + "<span style = 'color:#009e0f;'>" + getCommonTranslation(val) + "</span>";
            } else if (val == 'FORWARDED') {
                colorValue = getServiceRequestTranslation('EMM_FORWARDED_MINUTE_HISTORY_GRID_MESSAGE_FORWARDED') + "<span style = 'color:#2b78e4;'>" +  getServiceRequestTranslation('EMM_FORWARDED') + "</span>";
            }
            return colorValue;
        }
    }]
});