/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.eventmeetingminutes.EventMeetingMinutesGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.eventmeetingminutesgrid',
    store: 'eventmeetingminutes.EventMeetingMinutesStore',
    title: getServiceRequestTranslation('EMM_MANAGE_MINUTES'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'eventmeetingminutes.EventMeetingMinutesStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }, '->', {
        xtype: 'button',
        itemId: 'exportMeetingofMinutes',
        icon: 'resources/images/print1.png',
        tooltip: getCommonTranslation('EXPORTREPORTS'),
        formBind: true,
    }],
    columns: [{
        header: getServiceRequestTranslation('EMM_MINUTE_DATE'),
        dataIndex: 'minuteDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getServiceRequestTranslation('EVENT_NAME'),
        dataIndex: 'event',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value) && !isNullOrEmpty(value.eventName)) {
                return value.eventName;
            }
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_MINUTE_SUBJECT'),
        dataIndex: 'minuteSubject',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('EMM_MINUTE_TAKER'),
        dataIndex: 'minuteTakerName',
        flex: 1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('EMM_TOTAL_MINUTES'),
        dataIndex: 'totalNoOfMinute',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            return "<span style = 'color:#2b78e4;'>" + value + "</span>";
        }
    }, {
        header: getServiceRequestTranslation('EMM_TOTAL_PENDING_MINUTES'),
        dataIndex: 'totalNoOfPendingMinute',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            return "<span style = 'color:#cc0000;'>" + value + "</span>";
        }
    }, {
        header: getServiceRequestTranslation('EMM_TOTAL_FORWARDED_MINUTES'),
        dataIndex: 'totalNoOfForwardedMinute',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            return "<span style = 'color:#2b78e4;'>" + value + "</span>";
        }
    }, {
        header: getServiceRequestTranslation('EMM_TOTAL_COMPLETED_MINUTES'),
        dataIndex: 'totalNoOfCompletedMinute',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            return "<span style = 'color:#009e0f;'>" + value + "</span>";
        }
    }, {
        header: getServiceRequestTranslation('DOCUMENTS'),
        dataIndex: 'eventMeetingMinutesDocuments',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (value.length > 0) {
                    return "<a href='#'>" + value.length + "</a>";
                }
            }
            return '0';
        }
    }]
});