/**
 * @author Ashutosh Bhawsar
 */
Ext.define('Academia.view.examcancellation.ExamCancellationFilter', {
extend: 'Ext.form.Panel',
	alias: 'widget.examcancellationfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'examCancellationName',
			itemId:'examCancellationName',
			store:'examcancellation.ExamCancellationNameListStore',
			valueField: 'value',
			displayField: 'value',
			forceSelection:true,
			enableKeyEvents  : 'true',
			typeAhead:false,
			fieldLabel:getExaminationTranslation('EXAM_CANCELLATION_NAME'),
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    hideTrigger:false,
		    queryParam:'examCancellationName',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
				xtype: 'customcombobox',
        		width:226,
				name:'status',
				itemId:'status',
				fieldLabel: getCommonTranslation('STATUS'),
				minChars:3,
				displayField: 'value',
				valueField: 'id',
				forceSelection:true,
				store:Ext.create('Academia.store.examcancellation.ExamCancellationStatusEnumStore'),
		
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'quickSearchId',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
