/**
 * @author <a href="mailto:abhishek.chouhan@serosoft.in">Abhishek Chouhan</a>
 *
 */
Ext.define('Academia.view.examcancellation.ExamCancellationSetUpForm', {
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.examcancellationsetupform',
	autoScroll:false,
	layout: 'vbox',
	method: 'POST',
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	standardSubmit : false,
	plugins : "formlabelrequired",
	items : [ {
		xtype : 'hidden',
		name : 'id'
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'textfield',
			name : 'examCancellationName',
			itemId: 'examCancellationName',
			allowBlank : false,
			fieldLabel : getCommonTranslation('EXAM_CANCELLATION_NAME'),
			maxLength:200,
			allowOnlyWhitespace: false
		},{
			xtype : 'numberfield',
			name : 'maximumCourse',
			itemId: 'maximumCourse',
			allowBlank : false,
			fieldLabel : getCommonTranslation('MAX_COURSE_APPLICABLE'),
			allowExponential :false,
		    allowDecimals: false,
			minValue: 1,
			maxValue: 100
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			store:Ext.create('Academia.store.examcancellation.ExamCancellationStatusEnumStore'),
			name : 'status',
			itemId: 'status',
			displayField: 'value',
			valueField: 'id',
            forceSelection:true,
            typeAhead:true,
			allowBlank : false,
			fieldLabel : getCommonTranslation('STATUS'),
		},{
		xtype : 'fieldcontainer',
		width : 'auto',
		style:{marginLeft:'0px',marginTop:'25px'},
		defaults : {
			labelAlign : 'top',
		},
		layout : {
			type : 'hbox'
		},
		items : [{
            xtype: 'checkbox',
    		width : 300,
            name: 'autoApprove',
            itemId: 'autoApprove',
 			allowBlank:false,
            inputValue: true,
            uncheckedValue:false,
			boxLabel: getCommonTranslation('AUTO_APPROVE_EXAM_CANCELLATION_REQUEST'),
	    }]
	}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'examCancellatationSubmitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			itemId : 'examCancellatationCancelBtn',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		} ]
	} ]

});