/**
 * @author Vinay Kumrawat
 */
Ext.define('Academia.view.examinationattendancerule.AttendanceRuleGrid', {
	 extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.attendancerulegrid',
    title: getExaminationTranslation('ATTENDANCE_RULE_LIST'),
    store:'attendancerulestores.AttendanceRuleGridStore',
    border: true,
    autoScroll: false,
    cls: 'limitedColumnGrid',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   tbar: [{
       xtype: 'button',
       itemId: 'btnAdd_dc',
       tooltip: getCommonTranslation('ADD'),
       glyph: ICONGLYPH.ADDGLYPH,
   }, {
       xtype: 'button',
       itemId: 'btnEdit_dc',
       tooltip: getCommonTranslation('EDIT'),
       glyph: ICONGLYPH.EDITGLYPH,
       disabled: true
   }, {
       xtype: 'button',
       itemId: 'btnDelete_dc',
       tooltip: getCommonTranslation('DELETE'),
       glyph: ICONGLYPH.DELETEGLYPH,
       disabled: true
   }, {
       xtype: 'button',
       itemId: 'btnApplyTo_dc',
       tooltip: getCommonTranslation('APPLY_TO'),
       text: getCommonTranslation('APPLY_TO'),
       disabled: true
   }],
    columns: [{
        header: getExaminationTranslation('ATTENDANCE_RULE_NAME'),
        dataIndex: 'attendanceRule',
        flex:1
    }, {
        header: getCommonTranslation('PROGRAMS_ASSOCIATED'),
        dataIndex: 'programsAssociated',
        flex:1,
        renderer: function(value){
        	if(!isNullOrEmpty(value) && value!=0){
        		return '<a href="#">'+value+'</a>';
        	}else{
        		return '';
        	}
        }
    }],
    initComponent: function() {
        var this$ = this;
        Ext.apply(this$, {
           store: 'attendancerulestores.AttendanceRuleGridStore',
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: 'attendancerulestores.AttendanceRuleGridStore',
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    }
});