/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.AssessmentEventFilter', {
	extend: 'Academia.view.common.DynamicFieldForm',
	alias: 'widget.assessmenteventfilter',     
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype:'hidden',
		name:'academicTermId',
		itemId: 'academicTermId',
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top'      
		},
		items: [{
		xtype: 'customcombobox',
		width: 460,
		name: 'multiselectAcademyLocation',
		itemId: 'multiselectAcademyLocationId',
		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
		store:'user.UserAcademyLocationStore',
		displayField:'value',
		valueField:'id',
		autoloadStore: false,
		queryParam:'qry',
		minChars:3,
		typeAhead:false,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}' +
				'</div>';
			}
		}
		}]
		
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'program',
			itemId: 'programItemId',
			fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:'facilitiesresources.resourcemaster.ProgramGridStore',
			displayField:'codeValue',
			valueField:'id',
			maxLength:15000,
			autoloadStore: false,
			allowBlank:false,
			queryParam:'qry',
			minChars:3,
			typeAhead:false,
			//triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},	{
			xtype: 'customcombobox',
    		width:226,
			name:'BATCH_NAME',
			itemId:'batchId',
			fieldLabel: getExaminationTranslation('BATCH'),
			queryParam:'batchName',
//			queryMode:'local',
			minChars:3,
			displayField: 'value',
			valueField: 'id',
			forceSelection:true,
			disabled:true,
			allowBlank:false,
			store:'common.CurrentBatchStore',
	
	}
,{
            xtype: 'customcombobox',
            name: 'PERIOD_NAME',
            itemId: 'periodId',
            store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
            fieldLabel: getExaminationTranslation('PERIOD'),
  //        editable: false,
            disabled:true,
            allowBlank:false,
            queryMode: 'local',
            displayField: 'value',
            forceSelection:true,
            valueField: 'id',
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
        	xtype: 'customcombobox',
			name:'courseId',
			itemId:'courseItemId',
			store:Ext.create('Academia.store.attendance.CoursesForEvaluationStatus'),
			allowBlank:false,
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'courseName',
			minChars:3,
			typeAhead:false,
			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
        },{
			xtype: 'customcombobox',
			name:'evaluationplan',
			itemId:'evalautionPlanId',
			store:'examinationcenters.assessmentEvent.EvaluationPlanForEventStore',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			width: 226,
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			disabled:true,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}

		},{
			xtype: 'hidden',
			name: 'methodId',
			itemId:'methodId'
		},{
        	xtype: 'customcombobox',
        	name:'evaluationMethod',
			itemId:'evaluationMethodId',
            store:'examinationcenters.evaluation.SequenceNameByPlanId',
            displayField:'sequenceName',
            valueField:'sequenceHeaderId',
            typeAhead:true,
            allowBlank:false,
            disabled:true,
            fieldLabel:getExaminationTranslation('SEQUENCE_NAME'),
            forceSelection:true,
            maxLength: 1076,
        },{
        	xtype: 'customcombobox',
        	name:'weightageCombo',
			itemId:'weightageComboId',
            store:'examinationcenters.evaluation.MethodLevelWeightageStore',
            displayField:'evalSequenceWeightage',
            valueField:'sequenceHeaderId',
            typeAhead:true,
            allowBlank:true,
            disabled:true,
            queryMode:'local',
			// forceSelection:true,
            hidden:true,
            fieldLabel:getExaminationTranslation('WEIGHTAGE'),
            
        }]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'quickSearchId',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			itemId: 'manageHierarchyStatus',
			name:'manageHierarchyStatus',
			text: getExaminationTranslation('MANAGE_HIERARCHY_STATUS'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		}],
	}]

//}]
});