/**
 * Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.ManageHierarchyStatusWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.manageHierarchyStatusWindow',
	cls: 'manageHierarchyStatusWindow',
	modal: true,
	autoScroll:true,
	title:getExaminationTranslation('UPDATE_HIERARCHY_STATUS'),
	maxHeight:500,
	width: 560,
	height:230,
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'evaluationHierarchyStatus',
				itemId:'evaluationHierarchyStatusItemId',
				fieldLabel: getExaminationTranslation('HIERARCHY_STATUS'),
				store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationHierarchyStatusEnumStore'),
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				minChars:3,
				allowBlank: false
			},{
				xtype: 'customcombobox',
				name: 'evaluationTypeAcademic',
				itemId:'evaluationTypeAcademicItemId',
				fieldLabel: getExaminationTranslation('EVALUATION_TYPE'),
				store:Ext.create('Academia.store.examinationcenters.evaluation.EvaluationTypeMapped'),
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				minChars:3,
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'courseComponentAcademic',
				itemId:'courseComponentAcademicItemId',
				fieldLabel: getExaminationTranslation('EVALUATION_SUB_TYPE'),
				store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSubTypeMapped'),
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				disabled:true,
				minChars:3,
			},{
				xtype: 'customcombobox',
				name: 'sequenceHeaderId',
				itemId:'sequenceHeaderIdItemdId',
				fieldLabel: getExaminationTranslation('EVALUATION_SEQUENCE'),
				store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationMethodMapped'),
				displayField:'value',
				valueField:'id',
				queryParam:'name',
				disabled:true,
				forceSelection:true,
				typeAhead:true,
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'detailSequence',
				itemId:'detailSequenceItemId',
				store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.DetailSequenceEquivalentNo'),
				displayField:'value',
				valueField:'id',
				editable:false,
				disabled:true,
				hidden:true,
				queryMode: 'local',
				fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
			}]
		}, {
			xtype:'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'submitBtnWin',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});