/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.calculateAverage.SubjectAssessmentDetailsStructure', {
	extend : 'Ext.panel.Panel',
    alias: 'widget.subjectassessmentdetailsstructure',
    modal: false,
	autoScroll:false,
	frame: false,
	items: [{
		xtype:'form',
		name:'assessmentSubjectDetailForm',
		itemId:'assessmentSubjectDetailForm',
		items:[{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'studentCodeName',
				fieldLabel:'<b>'+getExaminationTranslation('STUDENT_ID_NAME')+'</b>'
			},{
				xtype:'displayfield',
				name:'gradeIntake',
				fieldLabel:'<b>'+getExaminationTranslation('GRADE_INTAKE')+'</b>'
			},{
				xtype:'displayfield',
				name:'sectionName',
				fieldLabel:'<b>'+getExaminationTranslation('CLASS')+'</b>'
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'assessmentLevelName',
				fieldLabel:'<b>'+getExaminationTranslation('ASSESSMENT_LEVEL')+'</b>'
			},{
				xtype:'displayfield',
				name:'assessmentLevelValue',
				fieldLabel:'<b>'+getExaminationTranslation('ASSESSMENT_LEVEL_NAME')+'</b>'
			},{
				xtype:'displayfield',
				name:'droolName',
				fieldLabel:'<b>'+getExaminationTranslation('DROOL')+'</b>'
			}]
		}]
	},{
		xtype: 'grid',
		name:'subjectAssessmentDetailGridItemId',
		itemId:'subjectAssessmentDetailGridItemId',
		border:true,
		autoScroll:false,
		frame: false,
		store:Ext.create('Academia.store.examinationcenters.calculateAverage.AssessmentSubjectListGridStore'),
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		title: '&nbsp;',
		style: {
			marginRight: 0
		},
		/*dockedItems: [{
		        xtype: 'toolbar',
		        dock: 'bottom',
		        cls: 'gridAverageToolbar',
		        items: [{
		            xtype: 'displayfield',
		            label: '',
		            value: 'Average',
		            style:{
		                'float': 'left'
		            }
		        },
		        {
		        	xtype: 'displayfield',
		        	label: '',
		        	value: '',
		        	itemId: 'asl_gradeAverage',
		            style:{
		                'float': 'right',
		                'position': 'initial !important'
		            }
		        }]
		    }],*/
		columns: [{
			header: getExaminationTranslation('SUBJECT_CODE'),
			dataIndex: 'courseCode',
			flex:.1,
			align:'left',
		},{
			header: getExaminationTranslation('SUBJECT_NAME'),
			dataIndex: 'courseName',
			flex:.1,
			align:'left',
		},{
			header: getExaminationTranslation('SUBJECT_OFFERING'),
			dataIndex: 'whetherOptional',
			flex:.1,
			align:'left',
			renderer:function(val,rec,e){
	    		if(!isNullOrEmpty(val)){
	    			if(val==true){
	    				return 'Optional';
	    			}else{
	    				return "Mandatory" ;
	    			}
	    		} else {
	    			return "-";
	    		}
	    	}
		},{
			header: getExaminationTranslation('SUBJECT_TYPE'),
			dataIndex: 'subjectType',
			flex:.1,
			align:'left',
			renderer:function(val,rec,e){
	    		if(!isNullOrEmpty(val)){
	    			if(val=="EXTENSION_AND_ENRICHMENT"){
	    				return getExaminationTranslation('EXTENSION_AND_ENRICHMENT');
	    			}else if (val=="THE_ARTS"){
	    				return getExaminationTranslation('THE_ARTS');
	    			}else {
		    			return val;
		    		}
	    		} 
	    	}
		},
		{
	        header: getExaminationTranslation('SUBJECT_MARKS'),
	        dataIndex: 'obtainedMarks',
	        align:'left',
	        flex:.1
	    },{
	        header: getExaminationTranslation('STATUS'),
	        dataIndex: 'revisedResultStatus',
	        flex:.1,
	        align:'left',
	        renderer:function(val,rec,e){
	        	if(!isNullOrEmpty(val)){
	        		return getExaminationTranslation(val);
	        	}
	    	},
	    },{
			xtype : 'checkcolumn', 
			flex:.1,
			itemId:'isCondoneSubject',
			text : getExaminationTranslation('WHETHER_CONDONED'), 
			dataIndex : 'isCondoneSubject',
			renderer: function(value, metadata,record) {
				var data=record.data;
				if(data.revisedResultStatus != 'PASS'){
					 var cssPrefix = Ext.baseCSSPrefix,
					 cls = cssPrefix + 'grid-checkcolumn';
					 if (value) {
							cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
						}
						return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
				}
			}
		}],
		 plugins: [{
			 ptype : 'cellediting',
			 clicksToEdit: 1,
			 listeners: {
				 edit: function(obj, editor, context){
					 var this$= this;
					 var grid = obj.grid;
					 var store = grid.getStore();
					 var models = grid.getStore().getRange();
					 for(var i =0; i<store.data.length;i++){
						 if(editor.rowIdx==i){
							 models[i].set('isCondoneSubject', false);
							 models[i].set('isCondoneSubject', false);
						 }
					 }
				 }
			 }
		 }]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
		        xtype: 'button',
		        itemId: 'btnsaveSubjectAssessmentDetail',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				style:{marginLeft:'10px !important'},
		        text:getExaminationTranslation('SAVE'),
		        tooltip: getExaminationTranslation('SAVE')
	    	}]	
		}]

	}],
	
});