/**
 * sumit.meena
 */
var EvalGroupListingDocumentGrid =Ext.create('Academia.store.examinationcenters.evaluationgrouplisting.documentsubmit.EvalGroupListingDocumentStore');
Ext.define('Academia.view.examinationcenters.evaluationgrouplisting.documentsubmit.EvalGroupListingDocumentGrid', {
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.evalgrouplistingdocumentgrid',
	store: EvalGroupListingDocumentGrid,
	border: true,
	autoScroll: false,
	title:getExaminationTranslation('DOCUMENT_LIST'),
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : EvalGroupListingDocumentGrid,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}
	],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}/*, {
		xtype: 'button',
		itemId: 'btnEdit',
		hidden:true,
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
		}, {
	        xtype: 'button',
	        itemId: 'btnView',
	        tooltip: getCommonTranslation('VIEW'),
	        iconCls: 'view-icon'
	    }, {
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH
	}*/],
	columns: [{
		header: getExaminationTranslation('DOCUMENT_NAME'),
		dataIndex: 'documentName',
		flex:.1,
		sortable:true
	}, {
		header: getExaminationTranslation('DATE'),
		dataIndex: 'submissionDate',
		flex:.1,
		sortable: true,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getExaminationTranslation('ELECTRONIC_DOCUMENTS'),
		dataIndex: 'isElectronic',
		flex:.1,
		sortable: true,
		renderer:function(value){
			if(value){
				return getCommonTranslation('YES');
			}else if(value){
				return getCommonTranslation('NO');
			}

		}
	}, {
		header: getExaminationTranslation('INSPECTION_REQUIRE'),
		dataIndex: 'isInspectionRequired',
		flex:.1,
		sortable: true,
		renderer:function(value){
			if(value){
				return getCommonTranslation('YES');
			}else if(!value){
				return getCommonTranslation('NO');
			}

		}
	}, {
		header: getExaminationTranslation('INSPECTION_DONE_B'),
		dataIndex: 'inspectionDoneBy',
		flex:.1,
		sortable: true,
		renderer:function(value){
			if(value){
				return value.value;
			}

		}
	}, {
		header: getExaminationTranslation('RETURNABLE_DOCUMEN'),
		dataIndex: 'isReturnable',
		flex:.1,
		sortable: true,
		renderer:function(value){
			if(value){
				return getCommonTranslation('YES');
			}else if(!value){
				return getCommonTranslation('NO');
			}
		}
	}, {
		header: getExaminationTranslation('RETURN_B'),
		dataIndex: 'returnedBy',
		flex:.1,
		sortable: true,
		renderer:function(value){
			if(value){
				return value.value;	
			}
		}
	}, {
		header: getExaminationTranslation('DOWNLOAD'),
		dataIndex: 'documentName',
		flex:.1,
		sortable: true,
		renderer:function(value){
			if(value){
				return '<a href="#">'+value+'</a>';	
			}
		}
	}]
});