/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationplanstatus.EvaluationStatusMasterGrid',{
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.evaluationstatusmastergrid',
	store: 'examinationcenters.evaluationplanstatus.EvaluationStatusGridStore',
	border: true,
	frame:false,
	title:getExaminationTranslation('MANAGE_EVALUATION_STATUS_LIST'),
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'examinationcenters.evaluationplanstatus.EvaluationStatusGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
		var grid=this;     
		/*if (portalId == 1) {
            this.headerFix = {
                headerFix: true,
                portalIdsWithStructure: {
                    'form': 1
                }
            };
        } else{
            this.headerFix = {  
                headerFix: true,
                portalIdsWithStructure: {
                    'personinfofacultyportal':2
                }
            };
        }*/
		              
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActionsEvent',
		text : getExaminationTranslation('CHANGE_EVENT_STATUS'),
		menu:[{
			text:getExaminationTranslation('CNTRL_PENDING'),
			tooltip: getExaminationTranslation('STUDENT_MAPPING_ENABLE'),
			itemId:'btnPendingEvent'	
		},{
			itemId: 'btnReopenEvent',
			tooltip: getExaminationTranslation('OPEN_FOR_MARKENTRY'),
			text:getExaminationTranslation('OPEN_FOR_MARKENTRY'),
		},{
			tooltip: getExaminationTranslation('CLOSE_EVENT_STATUS'),
			text:getExaminationTranslation('CLOSE_EVENT_STATUS'),
			itemId:'btnCloseEvent'	
		},{
			text:getExaminationTranslation('COMPLETED_MARK_ENTRY'),
			tooltip: getExaminationTranslation('COMPLETED_MARK_ENTRY'),
			itemId:'btnCompletedEvent'
		}]
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActionsHierarchy',
		hidden:true,
		text : getExaminationTranslation('CHANGE_HIERARCHY_STATUS'),
		menu:[{
			text:getExaminationTranslation('CNTRL_PENDING'),
			tooltip: getExaminationTranslation('STUDENT_MAPPING_ENABLE'),
			itemId:'btnPending'	
		}/*,{
					text:getExaminationTranslation('RE_OPEN_FOR_MARKENTRY'),
					tooltip: getExaminationTranslation('RE_OPEN_FOR_MARKENTRY'),
					itemId:'btnConducted'
				},{
					text:getExaminationTranslation('CLOSE_EVENT_STATUS'),
					tooltip: getExaminationTranslation('CLOSE_EVENT_STATUS'),
					itemId:'btnClosed'
				}*/,{
					text:getExaminationTranslation('COMPLETED_MARK_ENTRY'),
					tooltip: getExaminationTranslation('COMPLETED_MARK_ENTRY'),
					itemId:'btnCompleted'
				}]
	}],
	columns: [{
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable: true,
		hidden:true
	},{
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable: true,
		hidden:true
	},{
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable: true,
		hidden:true
	},{
		header: getExaminationTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		sortable: true,
		hidden:true
	},{
		header: getExaminationTranslation('EVALUATION_PLAN'),
		dataIndex: 'planName',
		flex:.3,
		sortable: true
	},{
		header: getExaminationTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.2,
		sortable: true
	}, {
		header: getExaminationTranslation('EVALUATION_TYPE'),
		dataIndex: 'type',
		flex:.1,
		sortable: true
	},{
		header: getExaminationTranslation('EVALUATION_TYPE_STATUS'),
		dataIndex: 'typeStatus',
		flex:.1,
		sortable: true,
		hidden:true,
		renderer:function(value){
			if(value=="PENDING"){
				return "Pending";

			}else if(value=="CLOSED"){
				return "Closed";

			}else if(value=="COMPLETED"){
				return "Completed";

			}else if(value=="CONDUCTED"){
				return "Conducted";

			}else{
				return value;
			}
		}
	},{
		header: getExaminationTranslation('EVALUATION_SUB_TYPE'),
		dataIndex: 'subType',
		flex:.2,
		sortable:true
	},{
		header: getExaminationTranslation('EVALUATION_SUB_TYPE_STATUS'),
		dataIndex: 'subTypeStatus',
		flex:.1,
		sortable: true,
		hidden:true,
		renderer:function(value){
			if(value=="PENDING"){
				return "Pending";

			}else if(value=="CLOSED"){
				return "Closed";

			}else if(value=="COMPLETED"){
				return "Completed";

			}else if(value=="CONDUCTED"){
				return "Conducted";

			}else{
				return value;
			}
		}
	},{
		header: getExaminationTranslation('EVALUATION_METHOD_VALUE'),
		dataIndex: 'method',
		flex:.1,
		sortable:true
	},{
		header: getExaminationTranslation('EVALUATION_METHOD_VALUE_STATUS'),
		dataIndex: 'methodStatus',
		flex:.1,
		sortable: true,
		hidden:true,renderer:function(value){
			if(value=="PENDING"){
				return "Pending";

			}else if(value=="CLOSED"){
				return "Closed";

			}else if(value=="COMPLETED"){
				return "Completed";

			}else if(value=="CONDUCTED"){
				return "Conducted";

			}else{
				return value;
			}
		}
	},{
		header: getExaminationTranslation('EVALUATION_EVENT'),
		dataIndex: 'event',
		flex:.1,
		sortable:true
	},{
		header: getExaminationTranslation('FACULTY'),
		dataIndex: 'facultyName',
		flex:.1,
		sortable:true
	},{
		header: getExaminationTranslation('EVENT_STATUS'),
		dataIndex: 'eventStatus',
		flex:.1,
		sortable:true,
		renderer:function(value){
			if(value=="PENDING"){
				return "Pending";

			}else if(value=="CLOSED"){
				return "Closed";

			}else if(value=="COMPLETED"){
				return "<sapn style=\'color:red\'>Result Declared</span>";

			}else if(value=="CONDUCTED"){
				return "<sapn style=\'color:green\'>Open For Mark Entry</span>";

			}else{
				return value;
			}
		}
	},{
		header: getExaminationTranslation('MARK_ENTRY_STATUS'),
		dataIndex: 'markEntryStatus',
		flex:.1,
		sortable:true,
		renderer:function(value){
			return '<a href=#>'+value+'</a>'
		}
	},{
		header: getCommonTranslation('ACADEMIC_TERM'),
		dataIndex: 'academicTermName',
		flex:.1,
		hidden:true
	}]
});