/**
 * @author bhanu ps
 */
var evaluationPlanGridStore = Ext.create('Academia.store.examinationcenters.evaluation.coverageDetails.EvaluationPlanGridStore');
Ext.define('Academia.view.examinationcenters.evalution.EvaluationPlanGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.evaluationplangrid',
	store: evaluationPlanGridStore,
	title: getExaminationTranslation('EVAL_PLAN_LIST'),
	border: true,
	refreshStoreData:true,
	frame:false,
//	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : evaluationPlanGridStore,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	
	tbar: [{
        xtype: 'button',
        itemId: 'searchResultGridBtnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'searchResultGridBtnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
   }, {
        xtype: 'button',
        itemId: 'searchResultGridBtnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
   },{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },'->',{
		xtype: 'button',
		itemId: 'exportReport',
		disabled:true,
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
	}],
	isGridConfigurable:true,
	enableColumnHide: false,
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	columns: [/*{
		header:  getExaminationTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
	},*/{
		header:  getCommonTranslation('EVALUATION_PLAN'),
		dataIndex: 'evaluationPlanNumber',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('TOTAL_ACADEMY_LOCATIONS') ,
		dataIndex: 'totalAcademyLocation',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.totalAcademyLocation == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:getCommonTranslation('TOTAL_COURSES'),
		dataIndex: 'totalCourse',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.totalCourse == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header: getCommonTranslation('TOTAL_COURSE_VARIANTS'),
		dataIndex: 'totalCourseVariant',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.totalCourseVariant == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:getCommonTranslation('TOTAL_PROGRAMS'),
		dataIndex: 'totalProgram',
		flex:.1,
		hidden:true,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.totalProgram == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:getCommonTranslation('TOTAL_SECTIONS'),
		dataIndex: 'totalSection',
		flex:.1,
		hidden:true,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.totalSection == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header: getCommonTranslation('TOTAL_EVALUATION_TYPES'),
		dataIndex: 'totalEvaluationType',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.totalEvaluationType == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:getCommonTranslation('TOTAL_EVALUATION_SUB_TYPES'),
		dataIndex: 'totalEvaluationSubType',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.totalEvaluationSubType == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:getCommonTranslation('TOTAL_EVALUATION_METHODS'),
		dataIndex: 'totalEvaluationMethod',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.totalEvaluationMethod == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:getCommonTranslation('TOTAL_EVALUATION_EVENTS'),
		dataIndex: 'totalEvent',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.totalEvent == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:  getCommonTranslation('EVAL_PLAN_STATUS'),
		dataIndex: 'evaluationPlanStatus',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.evaluationPlanStatus.toUpperCase()  == "PENDING"){
					return "<span style=\'color:green\'>"+getExaminationTranslation('CNTRL_PENDING') +"</span>";
				} 
				if(record.data.evaluationPlanStatus.toUpperCase()  == "COMPLETED"){
					return "<span style=\'color:red\'>"+getExaminationTranslation('COMPLETED') +"</span>";
				} 
				if(record.data.evaluationPlanStatus.toUpperCase() == "CLOSED"){
					return "<span style=\'color:red\'>"+getExaminationTranslation('CNTRL_CLOSED_CAMEL') +"</span>";
				}
				if(record.data.evaluationPlanStatus.toUpperCase()  == "MARK_TO_GRADE_TRANFORMED"){
					return "<span style=\'color:orange\'>"+getExaminationTranslation('MARK_TO_GRADE_TRANFORMED') +"</span>";
				}
			}                        
		},
		hidden:true
	}]
});
