/**
 * @author kuldeep.yadav
 */
Ext.define('Academia.view.examinationcenters.evalution.coverageDetails.EligibleCourseVariantGrid', {
   // extend: 'Ext.grid.Panel',
	 extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.eligiblecoursevariantgrid',
    store: 'examinationcenters.evaluation.coverageDetails.CoverageCourseGrid',
    title : getExaminationTranslation('ELIGIBLE_COURSE_VARIANTS_LIST'),
    border: true,
    autoScroll: true,
    frame:false,
    selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
    	mode:'MULTI',
    	showHeaderCheckbox: true,
    	allowDeselect: false,
    	checkOnly : true
    },
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [{
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.evaluation.coverageDetails.CoverageCourseGrid',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
    initComponent: function() {

        var grid=this;                   

        grid.addExportToolBarItems(grid);

        this.callParent(arguments);     

 },
 tbar: [{	
		
	        xtype: 'button',
	        itemId: 'btnLinkCVItemId',
	        scale: CONSTANTS.BUTTONSIZE,
	        tooltip: getExaminationTranslation('SAVE'),
	        text:getExaminationTranslation('SAVE'),
			 style:{
//					marginLeft:'5px',
					marginRight:'10px'
			}
		 },{ 
		    	 xtype:'textfield',
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR') +' by '+ getExaminationTranslation('COURSE_CODE'),
				 width: 300,
				 name:'courseVarinat',
				 itemId:'courseVarinatId',
				 cls: 'SearchTextFieldWithSmallHeader',
		},{
			xtype: 'customcombobox',
			name: 'eligibleAccountingYear',
			itemId: 'eligibleAccountingYear',
			emptyText: getCommonTranslation('ACADEMIC_TERM'),
			store:Ext.create('Academia.store.common.AcademicTermStore'),
			valueField : 'id',
			displayField : 'value',
			hidden:true,
			forceSelection:true,
			typeAhead:true
		},{
	        xtype: 'button',
	        itemId: 'btnReset',
	        tooltip: getExaminationTranslation('RESET'),
	        text:getExaminationTranslation('RESET')
	  
    }],
    columns: [{
        header: getExaminationTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        flex:.1,
        sortable:true
    }, {
        header: getExaminationTranslation('COURSE_CODE'),
        dataIndex: 'courseCode',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('PROGRAM_CODE_NAME'),
        dataIndex: 'programFullName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('SECTION'),
        dataIndex: 'sectionName',
        flex:.1,
        sortable:true
    },/*{
        header: getExaminationTranslation('PROGRAM_DETAILS'),
        dataIndex: 'sectionCount',
        flex:.1,
        renderer:function(value,meta,record){
        	if(value==0){
        		return value;
        	}
        	else {
				return '<a href=#>'+value+'</a>'
        	}
		}
    }*/],
    listeners:{
    	beforeselect:function(selModel,record,index){
    		if(!isNullOrEmpty(selModel.view.up())) {
    			var grid = selModel.view.up();
    			var gridItemId = grid.getItemId();
    			try {
    				var isViewOnly = Ext.ComponentQuery.query('contentPanel')[0].getActiveTab().down('evaluationplanbasicdetailform').isViewOnly;
    				if(isViewOnly == true) {
    					return false;
    				}
    			}
    			catch(e) {
    				//--
    			}				   			
    		}
    	}
    }
});