/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.examstaffallocation.StaffEventAllocationGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.staffeventallocationgrid',
    store : 'examinationcenters.examstaffallocation.StaffEventAlloationGrid',
    title : getExaminationTranslation('EVENTS_AVAILABLE'),
    border: true,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	removeSerialColumn:true,
	/* dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.examstaffallocation.StaffEventAlloationGrid',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],*/
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	 tbar: [{
	        xtype: 'button',
	        itemId: 'addBtn',
	        text:getExaminationTranslation('SAVE_MAPPING'),
	        tooltip: getExaminationTranslation('SAVE_MAPPING')
	    }],
	columns: [{
		 xtype: 'rownumberer',
		 header: getCommonTranslation('SNO'),
		 align :'center',
		 flex:.015,
		 dataIndex:'rownumberer',
	 	},{
		header: getCommonTranslation('ID'),
		dataIndex: 'groupDateBatchCenterId',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getExaminationTranslation('EXAMP_DATE'),
		dataIndex: 'scheduleDateSlot',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			if(date!=null){
				return date;
					//return Ext.Date.format(new Date(new Date(date).getTime() - new Date(date).getTimezoneOffset() * 60000), 'd/m/Y');
			}else{
				return 'NA';
			}
		
		}
	},{
		header:getExaminationTranslation('TIME_SLOT'),
		dataIndex: 'timeSlot',
		flex:.1,
		sortable:true,
		renderer: function(value) {   
		    if (!value || value === null || value.toString().toLowerCase().includes('null')) {
		        return 'NA';
		    }
		    return value;  
		}
 

	},{
		header:getExaminationTranslation('EVALUATION_PLAN'),
		dataIndex: 'evaluationPlanName',
		flex:.1,
		sortable:true
	},{
		header:getExaminationTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:getExaminationTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.1,
		sortable:true
	},{
		header:getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true,
	},{
		header:getExaminationTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		sortable:true
	},{
		header:getExaminationTranslation('DETAILED_SEQUENCE'),
		dataIndex: 'detailSequenceNumber',
		flex:.1,
		sortable:true
	}]
});
