/**
 * @author bhanu pratap singh
 */
Ext.define('Academia.view.examinationcenters.generatehallticket.GenerateHallticketWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.generatehallticketwin',
	title: getCommonTranslation("SELECT_HALL_TICKET_TEMPLATE"),
	modal: true,
	autoScroll:true,
	maxHeight:500,
	width: '40%',
	height:'20%',
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
	        xtype: 'hidden',
	        itemId: 'isPreExam',
	        name: 'isPreExam'
    	},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox',
        		//width: 226
			},
			defaults: {
				width: 300
			},
			items: [{
            	xtype: 'customcombobox',
            	itemId:'chooseHallticketTemplate',
        		name: 'chooseHallticketTemplateId',
        	    store:'setup.templatemapping.TemplateNameListFacultyByCode',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
        		displayField:'code',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
        		listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			},
        		allowBlank:false,
        		fieldLabel:getExaminationTranslation('TEMPLATE')
            },{
    	        xtype: 'fieldcontainer',
            	layout: 'hbox',
            	items:[{
            		xtype: 'button',
        			text: getCommonTranslation('PREVIEW_TEMPLATE_BTN'),
        			itemId: 'previewTemplateBtn',
        			buttonAlign: 'bottom',
        			ui: 'CustomBtnThird',
        			scale: CONSTANTS.BUTTONSIZE,
        			disabled:true,
        			formBind:true,
        			margin: '0 0 0 0'
            	}]
    		}]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("GENERATE") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				margin: '5px 0px 0px 105px',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                margin: '5px 0px 0px 5px',
                listeners: {
					click: function(obj) {
						obj.up().up().up().close();
					}
                }
            }]
		}]
	}]
});