/**
 * @author bhanu pratap singh
 */
Ext.define('Academia.view.examinationcenters.generatehallticket.GenerateTabulationReportWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.generatetabulationreportwin',
	title:getExaminationTranslation('GENERATE_REPORT'),
	modal: true,
//	autoScroll:true,
//	maxHeight:500,
	maxWidth: 450,
	minHeight: 180,
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: '0 0 0 38',
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'vbox'
			},
			defaults: {
				width: 400
			},
			items: [
				{
					xtype: 'customcombobox',
					itemId: 'periodDetails',
					name: 'periodDetails',
					store: 'setup.templatemapping.TemplatePeriodStore',
					displayField: 'value',
					valueField: 'id',
					width: 300,
					forceSelection: true,
					typeAhead: true,
					minChars: 3,
					hidden: true,
					listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function () {
							return '<div class="search-item">{value}</div>';
						},
						listeners: {
							beforeshow: function (picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						}
					},
					allowBlank: false,
					fieldLabel: getProgramandcourseTranslation('PERIOD'),
					listeners: {
						render: function (combo) {
							var store = combo.getStore();

							store.on('load', function (storeRecords) {
								if (storeRecords.getCount() === 1) {
									var onlyRecord = storeRecords.first();
									combo.setValue(onlyRecord.get(combo.valueField));
									combo.setReadOnly(true);
								} else {
									combo.setReadOnly(false);
									combo.reset();
								}
							}, this, { single: true });
						},
						select: function(combo) {
							var data = combo.up('form').down('#chooseTemplate').getStore().getRange(),
							genrateButton = combo.up('form').down('#submitBtn');

							if(!data.length){
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('NO_TEMPLATE_MAPPED'));
							}else{
								genrateButton.setDisabled(false);
							}
						}
					}
				},
				{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						margin: '0 10 0 0'
					},
					items: [{
							xtype: 'customcombobox',
							itemId: 'chooseTemplate',
							name: 'chooseTemplateId',
        	                store:'setup.templatemapping.TemplateNameForFoils',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
							displayField: 'code',
							valueField: 'id',
							forceSelection: true,
							typeAhead: true,
							width: 300,
							minChars: 3,
							listConfig: {
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function () {
    					           return '<div class="search-item">' +
    					             '{value}' +
    					             '</div>';
								},
								listeners: {
									beforeshow: function (picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								}
							},
							listeners: {
								select: function(combo) {
									var genrateButton = combo.up('form').down('#submitBtn'),
									previewTemplateBtn = combo.up('form').down('#previewTemplateBtn');

									genrateButton.setDisabled(false);
									previewTemplateBtn.setDisabled(false);
								}
							},
							allowBlank: false,
							fieldLabel: getExaminationTranslation('TEMPLATE')
						},{
							xtype: 'button',
							iconCls: 'icon-View',
							itemId: 'previewTemplateBtn',
							tooltip : getCommonTranslation('PREVIEW'),
//							formBind: true,
							disabled: true,
							style: 'width: 30px !important; top:2px;', 
						}]
				}]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			height: 200,
			defaults: {
				margin: '0 10 50 0'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("GENERATE") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				disabled: true
//				formBind : true
			},{
				xtype: 'button',
				text: getServiceRequestTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelButtonId',
				scale: CONSTANTS.BUTTONSIZE,
				listeners: {
					click: function(obj) {
						obj.up().up().up().close();
					}
				}
			}]
		}]
	}]
});