/**
 * @author Deepak Nigam
 * 
 */
Ext.define('Academia.view.examinationcenters.manageEvaluation.DownloadTemplateForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadTemplateForm',
	//plugins : "formlabelrequired",
	frame: false,
	method : 'POST',
	//cls:'customSearchPanel',
	standardSubmit : false,
	items : [
	   {
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top'
		},
	},
	 {
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top'
		},
		items: [{
      	  xtype: 'customcombobox',
          name: 'modeOfTranscation',
          itemId: 'modeOfTranscationId',
          fieldLabel: getExaminationTranslation('MODE_OF_TRANSACTION'),
//          translationKey: 'PROGRAM',
          width:226,
          displayField:'value',
		valueField:'id',
//          store:'Academia.store.student.report.ProgramWithAcademicTermStore',
          store: Ext.create('Academia.store.student.report.ModeOfTranscationStore'),
          allowBlank: false,
          forceSelection:true,
          hideTrigger:false,
          typeAhead:true,
    	  triggerAction: 'all',
          minChars:3,
          emptyText: getCommonTranslation('ENTER_THREE_CHAR'), 
          forceSelection:true,		            	
    },
    {
		xtype: 'customcombobox',
		name: 'evaluationType',
		 width:226,
		itemId:'evaluationTypeItemId',
		store:'examCenter.AssignSequence.EvaluationType',
		displayField:'value',
		valueField:'id',
		forceSelection:true,
		editable:false,
		typeAhead:true,
		allowBlank:false,
		fieldLabel:getExaminationTranslation('EVALUATION_TYPE'),
	},
	{
		xtype : 'customcombobox',
		fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
		name : 'importMarkEntryAcademicTerm',
		itemId : 'importMarkEntryAcademicTermId',
		displayField : 'value',
		valueField : 'id',
		store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
		typeAhead : true,
		editable:false,
		typeAhead:true,
		allowBlank:false,
		forceSelection : true,
	}]},
    {
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top'
		},
		items: [ {
			xtype: 'customcombobox',
			name:'evalautionPlanNo',
			itemId:'evalautionPlanNoItemId',
			store: Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanOtherForTemplate'),
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			width: 226,
			disabled:true,
			// typeAhead:true, /*Commented for V2D-434295*/
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},
		{
			xtype: 'customcombobox',
			name:'course_name',
			itemId:'courseItemId',
			store: 'attendance.CoursesFromEvaluationPlan',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'courseName',
			minChars:3,
			disabled:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			width:226,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},
		{
			xtype: 'multiselectcombofield',
			addAllSelector: false,
			name: 'courseVariant',
			itemId:'courseVariantItemId',
			width:460,
			labelAlign: 'top',
			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
			store:'attendance.CourseVariantMappedToPlanTemplate',
			displayField:'value',
			valueField:'id',
			autoloadStore: false,
			disabled:true,
			typeAhead:false,
			forceSelection:true,
			allowBlank: false,
			editable:false,
			matchFieldWidth: false,
			cls:'commonAutoHeightMultiselectField resetPasswordMultiselect',
			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					refresh: function( boundList, eOpts ){
						try{
							var combo = boundList.up('combo');
							try{
								var isDynamic = combo.up('form').down('#detailSequenceItemIdMapUnmap').getStore().getProxy().extraParams.isDynamicScheme;
							}
							catch(e){
								var isDynamic = false;
							}
							if(isDynamic==true || isDynamic=="true"){
								var newValue = combo.getValue();
								if(!isNullOrEmpty(newValue[0])){
									var allItems = combo.listKeyNav.boundList.all.elements;
									var selectedVariantId = 0;
									var selectedCourseId = 0;
									var comboStore = combo.getStore();
									if(typeof combo.getValue() == "string"){
										selectedVariantId = combo.getValue();
									}
									else{
										selectedVariantId = combo.getValue()[0].get('id');
									}
									if(selectedVariantId){
										var selectedRecord = comboStore.findRecord('id',selectedVariantId);
										var selectedCourseId = selectedRecord.get('courseId');
									}
									Ext.each(allItems, function(currentItem){
										var currentCourseVariantId = currentItem.viewRecordId;
										var currentCourseVariantRecord = comboStore.findRecord('id',currentCourseVariantId);
										if(currentCourseVariantRecord.get('courseId') == selectedCourseId){
											currentItem.classList.remove("disabledComboItem")
										}
										else{
											currentItem.classList.add("disabledComboItem");
										}
									});
								}
							}
						}
						catch(e){
							console.log(e);
						}
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
			listeners:{
				beforeselect:function(selModel,record,index){
					var combo = selModel.view.field;
					try{
						var isDynamic = combo.up('form').down('#detailSequenceItemIdMapUnmap').getStore().getProxy().extraParams.isDynamicScheme;
					}
					catch(e){
						var isDynamic = false;
					}
					if(isDynamic==true || isDynamic=="true"){
						if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
							var value = combo.getValue();
							if(value[0].data.courseId != record.data.courseId){
								return false;
							}
						}
					}
					else{
						return true;
					}
				},
				change: function(combo, newValue, oldValue, eOpt){
					var allItems = combo.listKeyNav.boundList.all.elements;
					var selectedVariantId = 0;
					var selectedCourseId = 0;
					var comboStore = combo.getStore();
					try{
						var isDynamic = combo.up('form').down('#detailSequenceItemIdMapUnmap').getStore().getProxy().extraParams.isDynamicScheme;
					}
					catch(e){
						var isDynamic = false;
					}
					if(isDynamic==true || isDynamic=="true"){
						if(typeof combo.getValue() == "string"){
							selectedVariantId = combo.getValue();
						}
						else{
							selectedVariantId = combo.getValue()[0];
						}
						if(selectedVariantId){
							var selectedRecord = comboStore.findRecord('id',selectedVariantId);
							var selectedCourseId = selectedRecord.get('courseId');
						}
						Ext.each(allItems, function(currentItem){
							var currentCourseVariantId = currentItem.viewRecordId;
							var currentCourseVariantRecord = comboStore.findRecord('id',currentCourseVariantId);
							if(currentCourseVariantRecord.get('courseId') == selectedCourseId){
								currentItem.classList.remove("disabledComboItem")
							}
							else{
								currentItem.classList.add("disabledComboItem");
							}
						});
					}
				}
			}
		},
		{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programIdQuickFiltr',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.MapUnmapProgramTemplateStore',//'common.ProgramStore',
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'programName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			autoloadStore: false,
			forceSelection:true,
			allowBlank:false,
			width: 226,
			hidden:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchIdQuickFiltr',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationBatchTemplateStore',//'common.BatchesByProgramId',
			displayField:'value',
			valueField:'id',
			editable:false,
			//forceSelection:true,
			typeAhead:true,
			hidden:true,
			allowBlank:false,
			width: 226,
			disabled:true,
			fieldLabel:getExaminationTranslation('BATCH')
		}, {
			xtype: 'customcombobox',
			name:'programIdForAcademicDynamic',
			itemId:'programIdForAcademicDynamic',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.MapUnmapProgramForDynamic',
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			autoloadStore: false,
			forceSelection:true,
			width: 226,
			hidden:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		}, {
			xtype: 'customcombobox',
			name: 'batchIdForAcademicDynamic',
			itemId:'batchIdForAcademicDynamic',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.MapUnmapBatchForDynamic',
			displayField:'value',
			valueField:'id',
			editable:false,
			//forceSelection:true,
			typeAhead:true,
			hidden:true,
			width: 226,
			disabled:true,
			fieldLabel:getExaminationTranslation('BATCH'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		}]
	},
	
	{
			xtype : 'fieldcontainer',
			items : [{
	            xtype: 'fieldcontainer',
	            width: '100%',
	            layout: 'hbox',
	            defaults: {
	                labelAlign: 'top'
	            },
	            items: [{
	    			xtype: 'customcombobox',
	    			name: 'periodId',
	    			itemId:'periodIdQuickFiltr',
	    			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationPeriodTemplateStore',//'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	    			displayField:'value',
	    			valueField:'id',
	    			editable:false,
	    			//forceSelection:true,
	    			allowBlank:false,
	    			width: 226,
	    			typeAhead:true,
	    			disabled:true,
	    			hidden:true,
	    			fieldLabel:getExaminationTranslation('PERIOD')
	    		}, {
	    			xtype: 'customcombobox',
	    			name: 'periodIdForAcademicDynamic',
	    			itemId:'periodIdForAcademicDynamic',
	    			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.MapUnmapPeriodForDynamic',
	    			displayField:'value',
	    			valueField:'id',
	    			editable:false,
	    			//forceSelection:true,
	    			width: 226,
	    			typeAhead:true,
	    			disabled:true,
	    			hidden:true,
	    			fieldLabel:getExaminationTranslation('PERIOD'),
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    						picker.maxWidth = picker.up('combobox').getSize().width;
	    					}
	    				}
	    			}
	    		}, {
	    			xtype: 'customcombobox',
	    			name: 'courseNameForDynamic',
	    			itemId:'courseNameForDynamic',
	    			labelAlign: 'top',
	    			fieldLabel:getExaminationTranslation('COURSE_CODE_NAME'),
	    			store:'examinationcenters.assessmentEvent.MappedStudentCoursesStore',
	    			valueField: 'id',
	    			displayField: 'value',
	    			queryParam:'courseName',
	    			autoloadStore: false,
	    			disabled:true,
	    			hidden: true,
	    			typeAhead:false,
	    			forceSelection:true,
	    			allowBlank: false,
	    			//editable:false,
	    			matchFieldWidth: true,
	    			width: 226,
	    			cls:'commonAutoHeightMultiselectField resetPasswordMultiselect',
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    						picker.maxWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{code}' +
	    					'</div>';
	    				}
	    			}
	    		}, {
	        			xtype: 'multiselectcombofield',
	        			name: 'sectionId',
	        			itemId:'sectionIdQuickFiltr',
	        			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSectionTemplateStore',//'coursetransaction.sectionmanagement.SectionsStore',
	        			displayField:'value',
	        			valueField:'id',
	        			disabled:true,
	        			allowBlank:false,
	        			width: 226,
	        			typeAhead:true,
	        			hidden:true,
	        			fieldLabel:getExaminationTranslation('SECTION'),
	        			listConfig: {
	        				listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	        				loadingText: getCommonTranslation('SEARCHING'),
	        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        				getInnerTpl: function() {
	        					return '<div class="search-item">' +
	        					'{value}' +
	        					'</div>';
	        				}
	        			}
	        		},
			            	{
			                    xtype: 'groupingcombobox',
			                    name: 'evalPlanLevelId',
			                    itemId:'evalPlanLevelItemId',
			                    editable:false,
			                    labelAlign:'top',
			                   // queryMode: 'local',
			                    groupField: 'code',
			                    groupDisplayField: 'code',
			                    store:Ext.create('Academia.store.examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId'),
			                    fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
			                    displayField: 'value',
			                   // valueField: 'id' ,
			                    minChar : 3,
			                    disabled:true,
			                    listConfig: {
				    				listeners: {
				    					beforeshow: function(picker) {
				    						picker.minWidth = picker.up('combobox').getSize().width;
				    						picker.maxWidth = picker.up('combobox').getSize().width;
				    					}
				    				}
				    			}
			                    /*listeners:{
			                    	select:function(obj,rec){
			                    		var data=rec[0].data.code;
			                    	}
			                    }*/
			                }]
			        },
			        {
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					labelAlign: 'top'
				},
				items :[{
					/*xtype: 'customcombobox',
					name: 'detailSequence',
					itemId:'detailSequenceItemId',
					store:Ext.create('Academia.store.examinationcenters.manageEvaluation.AssesmentEventStore'),
					displayField:'value',
					valueField:'id',
					forceSelection:true,
					editable:false,
					typeAhead:true,
					disabled:true,
					fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
					allowBlank: false,
					width: 175,
					listConfig: {
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        						picker.maxWidth = picker.up('combobox').getSize().width;
        					}
        				},
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				}
        			}*/
				
				xtype: 'multiselectcombofield',
				name: 'detailSequence',
				itemId:'detailSequenceItemIdMapUnmap',
				disabled:true,
				width: 460,
				cls:'receiptHeaderMultiselect resetPasswordMultiselect',
				//editable:false,
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				store:Ext.create('Academia.store.examinationcenters.manageEvaluation.AssesmentEventStore'),
				queryMode: 'local',
				fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
				disabled:true,
				allowBlank: false,
				//minChars:3,
				//emptyText: getCommonTranslation('ENTER_THREE_CHAR'), 
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				},
				/*select:function(obj){
                    var $this = this;
                    var downloadTemplateForm = this.getDownloadTemplateForm();
                    var downloadButton = downloadTemplateForm.down("#detailSequenceItemId")
                    $this.validateForm(downloadTemplateForm, downloadButton);
                }*/
				},
	            {
	                xtype: 'customcombobox',
	                name: 'courseCodeName_Course',	      
	                itemId:'courseCodeName',
	                disabled:true,
	                width: 460,
	                cls:'receiptHeaderMultiselect',
	                editable: false,
	                displayField: 'value',
	                valueField: 'id',
	                store: 'attendance.CoursesFromEvaluationPlan',
//	                store:'Academia.store.programCourseDashboard.ParameterisedCoursesStore',
//	                store:Ext.create('Academia.store.programCourseDashboard.ParameteriseCourseForSectionTransferStore'),
	                queryMode: 'local',
	                fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
	                hidden:true,
	                allowBlank: true,
	                minChars:3,
	    			autoloadStore: false,
			        emptyText: getCommonTranslation('ENTER_THREE_CHAR'), 
			        listConfig: {
	        			  listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	                        loadingText: getCommonTranslation('SEARCHING'),
	                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                        getInnerTpl: function() {
	                            return '<div class="search-item">' +
	                            '{value}'  +
	                            '</div>';
	                        }
	                    }
	            }
	            ]},
	            {
					xtype: 'fieldcontainer',
					layout: 'hbox',
					width: '100%',
					defaults: {
						labelAlign: 'top'
					}
					},
	            {
					xtype: 'fieldcontainer',
					width: '100%',
					layout : 'hbox',
					defaults : {
						labelAlign : 'top'
					},
					items: [{
			           	 xtype: 'button',
			        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
			             itemId: 'programBatchDownoladBtnId',
			             formBind : true,
			             ui: 'CustomBtnSubmit'
			        },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'resetBtn',
		                buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
				}]
	}]
});
