/**
 * @author sumit meena
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.manageEvaluation.EvaluationPlanFilter', {
	extend: 'Academia.view.common.DynamicFieldForm',
	//extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.evaluationplanfilter',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'evaluationType',
			itemId:'evaluationTypeItemId',
			store:Ext.create('Academia.store.examCenter.AssignSequence.EvaluationType'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN_TYPE'),
			allowBlank: false
		},{
			xtype: 'customcombobox',
			name:'evaluationStage',
			store:'examinationcenters.CenterUseFor',
			itemId:'evaluationStageItemId',
			fieldLabel: getExaminationTranslation('EVALUATION_STAGE'),
			displayField: 'value',
			valueField: 'id',
			typeAhead: true,
			forceSelection: true,
//			allowBlank: false
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'markEntryAcademicTerm',
			itemId : 'markEntryAcademicTermId',
			displayField : 'value',
			valueField : 'id',
			queryMode:'local',
			minChars:3,
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{value}' +
                    '</div>';
                }
            }
			/*listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStore');
					combo.bindStore(store)
				}
			}*/
		},{
			xtype: 'customcombobox',
			name:'markEntryProgramId',
			itemId:'markEntryProgramIdQuickFiltr',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationProgramStore'),
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'programName',
			minChars:3,
			//width:460,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			allowBlank:false,
			hidden:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		},{
			xtype: 'customcombobox',
			name: 'courseId',
			itemId: 'courseItemId',
			store:Ext.create('Academia.store.attendance.CoursesForVariantMapping'),
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'courseName',
			minChars:3,
			width:226,
			typeAhead:true,
			//triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'courseVariant',
			itemId:'courseVariantItemId',
			store:Ext.create('Academia.store.attendance.VariantMappedToPlan'),
			displayField:'value',
			valueField:'id',
			queryParam:'name',
			width:226,
			minChars:3,
			maxLength:9999,
			maxSelections :9999,
			forceSelection:true,
			allowBlank:false,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			},
			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
			//disabled:true
		},{
			xtype: 'customcombobox',
			name:'evalautionPlan',
			itemId:'evalautionPlanItemId',
			store:Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanByCriteria'),
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			width: 226,
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			disabled:true,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchIdQuickFiltr',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationBatchStore'),
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			hidden:true,
			disabled:true,
			allowBlank:false,
			fieldLabel:getExaminationTranslation('BATCH')
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodIdQuickFiltr',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationPeriodStore'),
			displayField:'value',
			valueField:'id',
			//forceSelection:true,
			typeAhead:true,
			disabled:true,
			hidden:true,
			allowBlank:false,
			fieldLabel:getExaminationTranslation('PERIOD')
		},{
			xtype: 'customcombobox',
			name: 'sectionId',
			itemId:'sectionIdQuickFiltr',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSectionStore'),
			displayField:'value',
			valueField:'id',
			width:226,
			disabled:true,
			//forceSelection:true,
			typeAhead:true,
			hidden:true,
			allowBlank:false,
			fieldLabel:getExaminationTranslation('SECTION')
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'evalautionPlanNo',
			itemId:'evalautionPlanNoItemId',
			store:'examinationcenters.evaluationgroup.detailsequencecovered.EvalGroupEvaluationPlanCombo',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			allowBlank:false,
			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			hidden:true,
			//allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype : 'radiogroup',
			fieldLabel:getExaminationTranslation('ANONYMOUS_EVALUATION_EVENT'),
			itemId:'anonymousEvent',
			labelAlign : 'top',
			hidden:true,
			items : [{
				boxLabel : getExaminationTranslation('YES'),
				name:'anonymousEvent',
				inputValue: true//,
				//id:'anonymousEventYesId'
			},{
				boxLabel : getExaminationTranslation('NO'),
				name:'anonymousEvent',
				inputValue: false,
				checked : true//,
				//id:'anonymousEventNoId'
			}]
		},{
			xtype:'hidden',
			name:'evaluationEventStatus'
		},{
			xtype:'hidden',
			name:'isDynamicScheme'
	},{
            xtype: 'groupingcombobox',
            name: 'evalPlanLevelId',
            itemId:'evalPlanLevelItemId',
            labelAlign:'top',
           // queryMode: 'local',
            groupField: 'code',
            groupDisplayField: 'code',
            store:Ext.create('Academia.store.examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
           // valueField: 'id' ,
            minChar : 3,
            disabled:true,
            forceSelection:true,
            /*listeners:{
            	select:function(obj,rec){
            		var data=rec[0].data.code;
            	}
            }*/
        },{
			xtype: 'customcombobox',
			name: 'detailSequence',
			itemId:'detailSequenceItemId',
			store:Ext.create('Academia.store.examinationcenters.manageEvaluation.EvaluationEventByEvalPlan'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			disabled:true,
			fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
			allowBlank: false,
		},
	{
		xtype: 'displayfield',
	    name:'minMarksGradeId',
		itemId:'minMarksGradeId',
		cls:'markGradCls',
		labelWidth: 130,
		width:170,
		fieldLabel: getExaminationTranslation('MIN_MARKS_GRADE'),
		fieldStyle:'font-weight: bold;',
		labelStyle:'margin-top:10px;margin-right: 8px; font-weight: bold;',
			labelAlign: 'left',
		margin: '26 0 0 0'
	},
	{
		xtype: 'displayfield',
		name:'maxMarksGradeId',
		itemId:'maxMarksGradeId',
		labelWidth: 130,
		width:170,
		cls:'markGradCls',
		fieldLabel: getExaminationTranslation('MAX_MARKS_GRADE'),
		fieldStyle:'font-weight: bold;',
		labelStyle:'margin-top:10px;margin-right: 8px; font-weight: bold;',
			labelAlign: 'left',
		margin: '26 0 0 0'
	},
	{
		xtype: 'displayfield',
    	itemId:'weightageId',
		name:'weightageId',
		labelWidth: 80,
		width:200,
		cls:'markGradCls',
		fieldLabel: getExaminationTranslation('WEIGHTAGE'),
		fieldStyle:'font-weight: bold;',
		labelStyle:'margin-top:10px;margin-right: 8px;font-weight: bold;',
			labelAlign: 'left',
		margin: '26 0 0 0'
	}	
		]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls:'windowBtnPos',
		items: [{
			xtype: 'button',
			itemId:'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		}, {
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype:'button',
			itemId:'markEntryDownload',
			hidden:true,
			text:getExaminationTranslation('MARK_ENTRY_DOWNLOAD'),
			ui: 'CustomBtnSubmit'
		},{
			xtype:'button',
			itemId:'markEntryUpload',
			text:getExaminationTranslation('MARK_ENTRY_UPLOAD'),
			ui : 'CustomBtnThird',
			hidden:true
		},{
            xtype: 'button',
            text: getExaminationTranslation('GENERATE_FOILS_REPORT'),
            itemId:'generateFoils',
            ui: 'CustomBtnThird',
            scale: CONSTANTS.BUTTONSIZE,
            disabled:true
//            formBind:true
            }]
	} 
	]
});
