/**
 * @author Amit G
 */
Ext.define('Academia.view.examinationcenters.questionPaperBank.VWExmQuestionTemplateGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
	alias: 'widget.vwexmquestiontemplategrid',
	store : 'examinationcenters.questionPaperBank.StoExmQuestionTemplateListDetailsStore',
	border: true,
	frame:false,
	refreshStoreData:true,
	title:getExaminationTranslation('LIST_QUESTION_TEMPLATE'),
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'examinationcenters.questionPaperBank.StoExmQuestionTemplateListDetailsStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getExaminationTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph : ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getExaminationTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getExaminationTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'academicTerm',
		hidden:true,
		flex:1
	},{
		header : getExaminationTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(!isNullOrEmpty(record.data.courseCode)){
					return record.data.courseCode+" / "+value;
				}else{
					return value;
				}
			} else {
				return '<span style=\'color:red\'>N/A</span>';
			}                       
		}
	},{
		header : getExaminationTranslation('EVALUATION_PLAN'),
		dataIndex : 'assesmentSchemeName',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				return '<span style=\'color:red\'>N/A</span>';
			}                       
		}
	},{
		header : getCommonTranslation('COURSE_VARIANTS'),
		dataIndex : 'courseVariantCount',
		flex:1,
		renderer:function(value,meta,record){
			if(value=='0' || value == '0.00' || value == '0.0'){
				return value;
			}else{
				return "<a href='#'>"+value+"</a>" ;
			}                     
		}

	},{
		header : getExaminationTranslation('DETAILED_SEQUENCE'),
		dataIndex : 'examEventName',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				return '<span style=\'color:red\'>N/A</span>';
			}                        
		}
	},{
		header : getExaminationTranslation('QUESTION_ASSOCIATED'),
		dataIndex : 'questionDetailCount',
		flex:1
	}]
});
