/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.remark.ClassTeacherGenerateRemarkWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.classTeacherGenerateRemarkWin',
    title: getExaminationTranslation('GENERATE_COMMENT'),
    frame: true,
    overflowX: 'hidden',
    overflowY: 'auto',
    modal: true,
    width: 1090,
    method: 'POST',
    height: 645,
    maxHeight: window.innerHeight - 20,
    reserveScrollbar: true,
    items: [{
        xtype: 'form',
        layout: {
            type: 'vbox'
        },
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            maxWidth: 1085,
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'displayfield',
                name: 'studentName',
                fieldLabel: '<b>' + getExaminationTranslation('STUDENT_NAME') + '</b>'
            }, {
                xtype: 'displayfield',
                name: 'gender',
                fieldLabel: '<b>' + getExaminationTranslation('GENDER') + '</b>'
            }, {
                xtype: 'displayfield',
                name: 'resultStatus',
                fieldLabel: '<b>' + getExaminationTranslation('EXAM_GRADE_RESULT_STATUS') + '</b>',
                renderer: function (val, rec, e) {
                    if (!isNullOrEmpty(val)) {
                        return val;
                    } else {
                        return '-';
                    }
                }
            }, {
                xtype: 'displayfield',
                name: 'attendance',
                fieldLabel: '<b>' + getCommonTranslation('PRESENT_ATTENDANCE') + '</b>'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'displayfield',
                name: 'absentAttendance',
                fieldLabel: '<b>' + getCommonTranslation('ABSENT_ATTENDANCE') + '</b>'
            }, {
                xtype: 'displayfield',
                name: 'program',
                fieldLabel: '<b>' + getExaminationTranslation('PROGRAM') + '</b>'
            }, {
                xtype: 'displayfield',
                name: 'batch',
                fieldLabel: '<b>' + getExaminationTranslation('BATCH') + '</b>'
            }, {
                xtype: 'displayfield',
                name: 'period',
                fieldLabel: '<b>' + getExaminationTranslation('PERIOD') + '</b>'
            }]
        }, {
            xtype: 'fieldcontainer',
            plugins: "formlabelrequired",
            width: 500,
            defaults: {
                labelAlign: 'top'
            },
            standardSubmit: false,
            items: [{
                xtype: 'textarea',
                name: 'personalObservation',
                itemId: 'personalObservation_hindi',
                fieldLabel: '<b>' + getExaminationTranslation('PERSONAL_OBSERVATION') + '</b>',
                maxLength: 1500,
                enterIsSpecial: true,
                width: 1000
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 1003,
            layout: 'hbox',
            margin: '0 0 16 0',
            items: [{
                xtype: 'tbspacer',
                flex: 1
            }, {
                xtype: 'button',
                action: 'Submit',
                text: getCommonTranslation('GENERATE'),
                itemId: 'generateBtnWin',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getCommonTranslation("RESET"),
                itemId: 'resetBtnWin',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }, {
            xtype: 'fieldcontainer',
            plugins: "formlabelrequired",
            width: 500,
            defaults: {
                labelAlign: 'top'
            },
            standardSubmit: false,
            items: [{
                xtype: 'textarea',
                name: 'remarkOutput',
                itemId: 'remarkOutput',
                height: 100,
                maxLength: 1500,
                enterIsSpecial: true,
                width: 1000,
                allowBlank: false
            }, {
                xtype: 'displayfield',
                name: 'remarkNotice',
                itemId: 'remarkNoticeId',
                width: 1000,
                value: '<span class="maxCharacterCls">' + getExaminationTranslation('MAX_CHARACTER_LENGTH') + " " + 1500 + '/' + 1500 + '</span>'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            items: [{
                xtype: 'button',
                action: 'Submit',
                text: getCommonTranslation("SAVE"),
                disabled: true,
                itemId: 'saveBtnWin',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getCommonTranslation("CANCEL"),
                itemId: 'cancelBtnWin',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});