/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.reports.ProgramLevelReportGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.programlevelreportgrid',
	store :  'examinationcenters.reports.ProgramLevelReportStore',
	title :  getExaminationTranslation('PROGRAM_LEVEL_REPORT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix: {
		headerFix: true,
		portalIdsWithStructure: {
			'examinationreports': 1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.reports.ProgramLevelReportStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
   },
   columns: [/*{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex : 1,
		hidden:true
	},*/
	{ // 0
		header : getCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex : 1
	},
	{ // 1 
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex : 1
	},
	{ // 2
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1
	},
	{ // 3
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},
	{ // 4
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},
	{ // 5
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1
	},
	
	{ // 6
		header : getCommonTranslation('PROGRAM_NAME'),
		dataIndex : 'programName',
		flex : 1
	},
	{ // 7
		header : getCommonTranslation('BATCH'), 
		dataIndex : 'batchName',
		flex : 1
	},
	{ // 8
		header : getCommonTranslation('SECTION'), 
		dataIndex : 'sectionName',
		flex : 1
	},
	{ // new 9  (Add new field for V2D-46057 epic)
		header : getExaminationTranslation('OUT_OF_MARKS'),
		dataIndex : 'marksObtainedFrom',
		flex : 1
	},
	{   // old 9 : new 10
		header : getExaminationTranslation('MARKS_OBTAIN'),
		dataIndex : 'obtainedMark',
		flex : 1
	},
	{ // new 11 (Add new field for V2D-46057 epic)
		header : getCommonTranslation('PERCENTAGE'),
		dataIndex : 'percentage',
		flex : 1,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return "-";
			}
		}
	},
	{ // old 10  new 12
		header : getExaminationTranslation('CGPA'),
		dataIndex : 'cgpa',
		flex : 1
	},
	{ // old 11  new 13
		header : getExaminationTranslation('PROGRAM_RANK'),
		dataIndex : 'programRank',
		flex : 1,
		hidden:false
	},
	{ // old 12  new 14
		header : getExaminationTranslation('SECTION_RANK'),
		dataIndex : 'sectionRank',
		flex : 1
	},
	{
		header : getExaminationTranslation('EXAM_RESULT_STATUS'),
		dataIndex : 'examResultStatus',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value))
				return Ext.util.Format.capitalize(getExaminationTranslation(value));
			else
				return ''
		}
	},
	{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'activeInactiveStatus',
		flex : 1,
		hidden :true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value))
				return getExaminationTranslation(value);
			else
				return '';
		}
	},
	{
		header : getExaminationTranslation('GRADE_POINT'),
		dataIndex : 'gradePoint',
		flex : 1,
		hidden:true
	},
	{
		header : getExaminationTranslation('CREDIT_SUM'),
		dataIndex : 'creditSum',
		flex : 1,
		hidden:true
	},
	{
		header : getExaminationTranslation('OBTAINED_CREDIT_SUM'),
		dataIndex : 'obtainedCreditSum',
		flex : 1,
		hidden:true
	},
	{
		header : getExaminationTranslation('CREDIT_GRADE_POINT_SUM'),
		dataIndex : 'creditGradePointSum',
		flex : 1,
		hidden:true
	},
	{
		header : getExaminationTranslation('OBTAINED_GRADE_POINT_SUM'),
		dataIndex : 'obtainedGradePointSum',
		flex : 1,
		hidden:true
	},
	{
		header : getExaminationTranslation('PENALTY_MARKS'),
		dataIndex : 'penultyMarksGiven',
		flex : 1,
		hidden:true
	},
	{
		header : getExaminationTranslation('GRACE_MARKS'),
		dataIndex : 'graceMarksGiven',
		flex : 1,
		hidden:true
	},{
		header : getExaminationTranslation('AVERAGE_MARKS'),
		dataIndex : 'planLevelAverage',
		flex : 1,
		hidden:true,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return  '<a href="#">'+value+'</a>';
			}else{
				return "-";
			}
		}
	},{
		header : getExaminationTranslation('GRADE_OBTAINED'),
		dataIndex : 'gradeObtained',
		flex : 1,
		hidden:true
	}]
	
});
