/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.examinationcenters.reports.StudentAssessmentReportGrid', {
    extend: 'Ext.tree.Panel',
    alias: 'widget.studentassessmentreportgrid',
    title: getExaminationTranslation('STUDENT_ASSESSMENT_REPORT'),
    titleAlign: 'center',
    border: true,
    cls: 'studentassessmentreportgrid no-tree-icon treeGrid',
    rootVisible: false,
    singleExpand: false,
    reserveScrollbar: true,
    height: window.innerHeight-250,
    useArrows: false,
    disableSelection: true,
	frame:false,
	rowLines: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/*headerFix:{
    	headerFix: true,
    	portalIdsWithStructure: {
    		'studentassessmentreportstructure': 1
    	}
    },*/
    tbar : [{
        xtype: 'button',
        itemId: 'studentCommentbtnDeleteId',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        iconCls: 'icon-Delete',
		cls:'iconDelete',
        disabled: true
    },{
	    xtype : 'button',
	    itemId : 'publishStudentAssessmentReportItemId',
	    tooltip : getExaminationTranslation('PUBLISH'),
	    text : getExaminationTranslation('PUBLISH'),
	   disabled: true
	},
	{
	    xtype : 'button',
	    itemId : 'sendMessageStudentAssessmentReportItemId',
	    tooltip : getCommonTranslation('SEND_MESSAGE'),
	    text : getCommonTranslation('SEND_MESSAGE'),
	    disabled: true
	},{
	    xtype : 'button',
	    itemId : 'unpublishTheGradeBook',
	    tooltip : getExaminationTranslation('UNPUBLISH_GRADE_BOOK'),
	    text : getExaminationTranslation('UNPUBLISH_GRADE_BOOK'),
	    disabled: true
	},
	{
	    xtype : 'button',
	    itemId : 'publishProgressionStatus',
	    tooltip : getExaminationTranslation('PUBLISH_PROGRESSION_STATUS'),
	    text : getExaminationTranslation('PUBLISH_PROGRESSION_STATUS'),
	    disabled: true
	}, {
		 xtype: 'button',
		 text:getExaminationTranslation('UNPUBLISH'),
		 itemId:'unpublishItemId',
		 //ui: 'CustomBtnSubmit',
		 //scale: CONSTANTS.BUTTONSIZE,
		 tooltip: getExaminationTranslation('UNPUBLISH'),
		 disabled: true
	 }, '->',{
	    xtype : 'button',
	    itemId : 'exportStudentAssessmentGradeBookReportItemId',
	    tooltip : getCommonTranslation('EXPORT_GRADE_BOOK'),
	    text : getCommonTranslation('EXPORT_GRADE_BOOK'),
	    disabled: true
	},{
	    xtype : 'button',
	    itemId : 'exportStudentAssessmentReportItemId',
	    tooltip : getCommonTranslation('EXPORTREPORTS'),
	    text : getCommonTranslation('EXPORTREPORTS'),
	    disabled: true
	}],
	store: 'examinationcenters.reports.StudentAssessmentReportGridStore',
    columns: [{
		header:  "<input type='checkbox'>",
		width: 42,
		hideable : false,
		menuDisabled: true,
		resizable: false,
		sealed: true
	},{
        xtype: 'treecolumn',
        text: getExaminationTranslation('STUDENT_ID')+" / "+getExaminationTranslation('STUDENT_NAME'),
        flex: .33,
        dataIndex: 'treeNode'
    },{
		header:  getExaminationTranslation('EVALUATION_PLAN'),
		dataIndex: 'evaluationPlanName',
		flex:.1,
		hidden: true
	},{
		header:  getCommonTranslation('DATE_SUBMITTED'),
		dataIndex: 'conductedDate',
		flex:.15
	},{
		header:  getExaminationTranslation('RAW_SCORE'),
		dataIndex: 'eventMarksObtained',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(rec.record.get('whetherExamAttended')==false){
					return "Ab";
				}
				if(isNullOrEmpty(val)){
					return '-';
				}
				if(!isNullOrEmpty(rec.record.get('whetherExamAttended'))){
					if(rec.record.get('whetherExamAttended')==false){
						return "Ab";
					}else{
						//var values=rec.record.get('eventMarksObtained'); 
						return Ext.util.Format.number(rec.record.get('eventMarksObtained'), '0.00');
					}

				}else{
					//var values1=rec.record.get('eventMarksObtained');
					return Ext.util.Format.number(rec.record.get('eventMarksObtained'), '0.00');
				}
			}
			else {
				if (isNullOrEmpty(val)) {
					return '-';
				}
				else {
					//var values1=rec.record.get('eventMarksObtained');
					return Ext.util.Format.number(rec.record.get('eventMarksObtained'), '0.00');
				}
			}
		},
	},{
		header:  getExaminationTranslation('MAX_RAW_SCORE'),
		dataIndex: 'eventTotalMarks',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return Ext.util.Format.number(val, '0.00');
				} else {
					return '-';
				}
			} else {
				if (!isNullOrEmpty(val)) {
					return Ext.util.Format.number(val, '0.00');
				} else {
					return '-';
				}
			}
		}
		//renderer  : Ext.util.Format.numberRenderer('0.00'),
	},{
		header:  getExaminationTranslation('SCORE_AS_A_PERCENTAGE'),
		dataIndex: 'eventPercentageObtained',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return Ext.util.Format.number(val, '0.00');
				} else {
					return '-';
				}
			} else {
				if (!isNullOrEmpty(val)) {
					return Ext.util.Format.number(val, '0.00');
				} else {
					return '-';
				}
			}
		}
		//renderer  : Ext.util.Format.numberRenderer('0.00'),
	},{
		header:  getExaminationTranslation('PERCENTAGE_WEIGHT'),
		dataIndex: 'eventWeightage',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return Ext.util.Format.number(val, '0.00');
				} else {
					return '-';
				}
			}
		}
		//renderer  : Ext.util.Format.numberRenderer('0.00'),
	},{
		header:  getExaminationTranslation('WEIGHTED_SCORE_AS_A_PERCENTAGE'),
		dataIndex: 'weigtageOfObtainedPercentage',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return Ext.util.Format.number(val, '0.00');
				} else {
					return '-';
				}
			}
		}
    	//renderer  : Ext.util.Format.numberRenderer('0.00'),
	},{
		header:  getExaminationTranslation('NUMERICAL_GRADE'),
		dataIndex: 'numericalGrade',
		flex:.1,
		hidden: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return val;
				} else {
					return '-';
				}
			}
		}
	},{
		header:  getExaminationTranslation('WEIGHTED_GRADE'),
		dataIndex: 'weightedGrade',
		flex:.1,
		hidden: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return val;
				} else {
					return '-';
				}
			}
		}
	},{
		header: getExaminationTranslation('ASSESSMENT_CODE'),
		dataIndex: 'eventGradeObtained',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return val;
				} else {
					return '-';
				}
			} else {
				if (!isNullOrEmpty(val)) {
					return val;
				} else {
					return '-';
				}
			}
		}
	},{
		header:  getExaminationTranslation('TEACHER_COMMENT'),
		dataIndex: 'eventRemark',
		flex:.1
	},{
		header:  getExaminationTranslation('STUDENT_COMMENT'),
		dataIndex: 'studentEventRemark',
		flex:.15,
		renderer: function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf() && record.data.portalId=="1"){
				if(isNullOrEmpty(val)){
					val = "Add comment";
				}
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
				return "<a href='#'>"+val+"</a>";
			} else {
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
				return val;
			}
		}
	},{
		header:  getExaminationTranslation('REPORT_STATUS'),
		dataIndex: 'whetherPublish',
		flex:.15,
		renderer: function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(isNullOrEmpty(val) || val==false){
					return "Not Published";
				}
				return "Published";
			}
			return "";
		}
	},{
		header:  getExaminationTranslation('GRADEBOOK_PUBLISH_STATUS'),
		dataIndex: 'status',
		flex:.15,
		renderer: function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){			
					if(val == 'UNPUBLISHED'){
						return 'Not Published';
					}else if(val == 'Hold For Student'){
						return  getExaminationTranslation('HOLD_FOR_STUDENT');
					}else
					{
						return 'PUBLISHED'
					}
					
				}
			}
		}
	},{
		header:  getCommonTranslation('TEMPLATE_NAME'),
		dataIndex: 'tmplateName',
		flex:.15,
		renderer: function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return val;
				}
			}
		}
	},{
		header:  getExaminationTranslation('PUBLISHED_DATE'),
		dataIndex: 'publishDate',
		hidden: true,
		flex:.15
	},{
		header:  getExaminationTranslation('PROGRAM_NAME'),
		dataIndex: 'program',
		flex:.1,
		hidden:  true
	},{
		header:  getProgramandcourseTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		hidden:  true
	},{
		header:  getProgramandcourseTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		hidden:  true
	},{
		header:  getExaminationTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.1,
		hidden:  true
	},{
		header:  getExaminationTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.1,
		hidden:  true
	}]
});