/**
 * @Author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.revaluation.ProgramMappingStructure', {
    extend: 'Ext.form.Panel',
    alias: 'widget.programmappingstructure',
    frame: true,
    items: [{
        xtype: 'form',
        method: 'POST',
        margin: 0,
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            autoScroll: true
        },
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'fieldcontainer',
            layout: {
                type: 'vbox'
            },
            items: [{
                xtype: 'fieldcontainer',
                frame: true,
                items: [{
                    xtype: 'displayfield',
                    name: 'revaluationName',
                    itemId: 'revaluationName',
                    fieldLabel: getExaminationTranslation('REVALUATION_CODE_NAME'),
                    labelAlign: 'top',
                    width: '100%'
                }]
            }, {
                xtype: 'fieldcontainer',
                frame: true,
                items: [{
                    xtype: 'button',
                    text: getCommonTranslation('SAVE'),
                    itemId: 'periodMappingBtn',
                    formBind: true,
                    ui: 'CustomBtnSubmit'
                }]
            }, {
                xtype: 'fieldcontainer',
                layout: {
                    type: 'hbox'
                },
                items: [{
                    xtype: 'fieldcontainer',
                    itemId: 'programBatchContainerId',
                    items: [{
                        xtype: 'fieldcontainer',
                        width: '100%',
                        itemId: 'programBatchContainer',
                        layout: 'hbox',
                        defaults: {
                            labelAlign: 'top',
                            width: 180
                        },
                        items: [{
                            xtype: 'customcombobox',
                            name: 'PROGRAM_NAME',
                            itemId: 'program',
                            fieldLabel: getPersonModuleTranslation('PROGRAM'),
                            valueField: 'id',
                            displayField: 'value',
                            minChars: 3,
                            queryParam: 'programName',
                            allowBlank: false,
                            style: {
                                marginRight: '10px !important'
                            },
                            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                            listeners: {
                                render: function (combo) {
                                    var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
                                    combo.bindStore(store);
                                },
                                select: function (obj, record) {
                                    var programId = record[0].get("id");
                                    var batch = obj.nextSibling();
                                    var period = batch.nextSibling();

                                    batch.setDisabled(false);
                                    batch.reset();

                                    period.setDisabled(true);
                                    period.reset();

                                    var store = batch.getStore();

                                    store.proxy.extraParams = {
                                        id: programId
                                    };
                                    store.load();
                                },
                                change: function (cmb) {
                                    if (isNullOrEmpty(cmb.getValue())) {
                                        cmb.getStore().load();
                                    }
                                }
                            },
                            listConfig: {
                                listeners: {
                                    beforeshow: function (picker) {
                                        picker.minWidth = picker.up('combobox').getSize().width;
                                    }
                                },
                                loadingText: getCommonTranslation('SEARCHING'),
                                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                                getInnerTpl: function () {
                                    return '<div class="search-item">' +
                                        '{value}' +
                                        '</div>';
                                }
                            }
                        }, {
                            xtype: 'customcombobox',
                            name: 'BATCH_NAME',
                            itemId: 'batch',
                            fieldLabel: getPersonModuleTranslation('BATCH'),
                            disabled: true,
                            editable: false,
                            allowBlank: false,
                            queryMode: 'local',
                            displayField: 'value',
                            valueField: 'id',
                            listeners: {
                                render: function (combo) {
                                    var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
                                    combo.bindStore(store);
                                },
                                select: function (obj, record) {
                                    var batchId = record[0].get("id");
                                    var period = obj.nextSibling();

                                    period.setDisabled(false);
                                    period.reset();

                                    var store = period.getStore();

                                    store.proxy.extraParams = {
                                        id: batchId
                                    };
                                    store.load();
                                }
                            }
                        }, {
                            xtype: 'customcombobox',
                            itemId: 'period',
                            disabled: true,
                            editable: false,
                            displayField: 'value',
                            valueField: 'id',
                            queryMode: 'local',
                            allowBlank: false,
                            fieldLabel: getPersonModuleTranslation('PERIOD'),
                            name: 'PERIOD_NAME',
                            listeners: {
                                render: function (combo) {
                                    var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                                    combo.bindStore(store);
                                },
                                select: function (obj, record) {
                                    obj.up('form').down('#fromdate').setDisabled(false);
                                    /*var periodId = record[0].get("id");
									var  section = obj.nextSibling();

									section.setDisabled(false);
									section.reset();

									var store = section.getStore();

									store.proxy.extraParams = {
											periodId : periodId
									};
									store.load();*/
                                }
                            }
                        }, {
                            xtype: 'datefield',
                            name: 'fromdate',
                            allowBlank: false,
                            editable: false,
                            itemId: 'fromdate',
                            fieldLabel: getCommonTranslation('START_DATE'),
                            disabled: true,
                            //--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
                            //vtype: 'daterange',
                            endDateField: 'tilldate',
                            minValue: new Date(), //V2D-404152  
                            listeners: {
                                render: function (field) {
                                    return dateFormatRender(field);
                                },
                                change: function (dateFld, newValue, oldValue) {
                                    //V2D-356701 //V2D-356706
                                	var tilldate = dateFld.up('form').down('#tilldate');
                                	tilldate.setMinValue(newValue);
                                    tilldate.setDisabled(false);
                                }
                            }
                        }, {
                            xtype: 'datefield',
                            name: 'tilldate',
                            itemId: 'tilldate',
                            fieldLabel: getCommonTranslation('END_DATE_LABEL'),
                            allowBlank: false,
                            disabled: true,
                            editable: false,
                            //vtype: 'daterange',
                            startDateField: 'fromdate',
                            endDateField: 'approvalEndDate',
                            //--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
                            listeners: {
                                render: function (field) {
                                    return dateFormatRender(field);
                                },
                                change: function (dateFld, newValue, oldValue) {
                                    //V2D-356701 //V2D-356706
                                	var form = dateFld.up('form');
                                	form.down('#fromdate').setMaxValue(newValue);
                                	var approvalEndDate = form.down('#approvalEndDate');
                                	approvalEndDate.setMinValue(newValue);
                                    approvalEndDate.setDisabled(false);
                                }
                            }
                        }, {
                            xtype: 'datefield',
                            name: 'approvalEndDate',
                            itemId: 'approvalEndDate',
                            fieldLabel: getExaminationTranslation('APPROVAL_END_DATE_LABEL'),
                            width: 205,
                            allowBlank: false,
                            disabled: true,
                            editable: false,
                            startDateField: 'tilldate',
                            listeners: {
                                render: function (field) {
                                    return dateFormatRender(field);
                                },
                                change: function (dateFld, newValue, oldValue) {
                                    dateFld.up('form').down('#tilldate').setMaxValue(newValue);
                                }
                            }
                        }, {
                            xtype: 'button',
                            itemId: 'addFilterBtn',
                            cls: 'CustomBodyBtnSettings',
                            text: getCommonTranslation('ADDBUTTONTEXT'),
                            tooltip: getCommonTranslation('ADD'),
                            style: {
                                marginTop: '30px'
                            }
                        }]
                    }]
                }]
            }]
        }]
    }]
});