/**
 * @author bhanu ps
 */
var revaluationCount=0;
var studentListRevalGridStore=Ext.create('Academia.store.examinationcenters.studentportal.revaluation.StudentListRevalGridStore');
var indexValue=[];
Ext.define('Academia.view.examinationcenters.revaluation.RevaluationCoreErpStudentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.revaluationcoreerpstudentgrid',
	store: studentListRevalGridStore,
	title: getExaminationTranslation('APPLY_FOR_REVALUATION'),
	itemId: 'revaluationcoreerpstudentgridId',
	border: true,
	frame:false,
	refreshStoreData:true,
//	enableColumnHide : false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		markDirty:false,
	},
	isGridConfigurable:true,
	enableColumnHide: false,
	selModel: {
		multiSelect :true,
    	mode:'SIMPLE',
    	checkOnly : true
	},
	
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : studentListRevalGridStore,//'examinationcenters.studentportal.revaluation.StudentListRevalGridStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnApplyNowItemId',
		tooltip:getExaminationTranslation('APPLY_NOW'),
		text:getExaminationTranslation('APPLY_NOW'),
		disabled:false  
	},{
		xtype: 'button',
		itemId: 'btnApplyItemId',
		tooltip:getExaminationTranslation('APPLY_AND_PAYONLINE'),
		text:getExaminationTranslation('APPLY_AND_PAYONLINE')
	},{
		xtype: 'button',
		itemId: 'offlinePaymentItemId',
		tooltip: getExaminationTranslation('APPLY_AND_PAYOFFLINE'),
		text:getExaminationTranslation('APPLY_AND_PAYOFFLINE'),
		//hidden: true
	},{
		xtype: 'button',
		itemId: 'btnApprove',
		tooltip: getExaminationTranslation('APPROVE_REJECT'),
		text: getExaminationTranslation('APPROVE_REJECT'),
	},{
		xtype: 'button',
		itemId: 'btnRefreshItemId',
		tooltip: getCommonTranslation('REFRESH_SELECTION'),
		text: getCommonTranslation('REFRESH_SELECTION'),
        //formBind:true
	},{
		xtype:'displayfield',
		name : 'applyForRevalMsg',
		itemId : 'applyForRevalMsgId',
		hidden:true
	}],
	
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
        header: getCommonTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex:.1,
        sortable: true
    }, {
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex:.1,
        sortable: true
    },{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.1,
        sortable: true
    },{
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.1,
        sortable: true
    },{
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex:.1,
        sortable: true
    },{
		header:  getCommonTranslation('COURSE_CODE'),
		dataIndex: 'courseCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariant',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('FACULTY_NAME'),
		dataIndex: 'facultyName',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation('DETAILED_SEQUENCE'),
		dataIndex: 'event',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation('MAX_MARKS'),
		dataIndex: 'maxMarks',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.maxMarks)){
				return record.data.maxMarks;
			}
		},
		hidden:true
	},{
		header:  getCommonTranslation('MAX_GRADE'),
		dataIndex: 'maxGrade',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.maxGrade)){
				return record.data.maxGrade;
			}
		},
		hidden:true
	},{
		header:  getCommonTranslation('MARKS_OBTAINED'),
		dataIndex: 'obtainedMarks',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(record.data.obtainedMarks)){
				return record.data.obtainedMarks;
			} 
		}
	},{
		header:  getCommonTranslation('GRADE_OBTAINED'),
		dataIndex: 'finalGrade',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(record.data.finalGrade)){
				return record.data.finalGrade;
			} 
		}
	},{
		header:  getCommonTranslation('RESULT_STATUS'),
		dataIndex: 'resultStatus',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(record.data.resultStatus)){
				if(record.data.resultStatus.toUpperCase()== getCommonTranslation("PASS").toUpperCase()) {
					return "<span style='color:green'>"+getCommonTranslation(record.data.resultStatus)+"</span>";
				} else {
					return "<span style='color:red'>"+getCommonTranslation(record.data.resultStatus)+"</span>";
				}
			}
		}
	},{
		header:  getCommonTranslation('REVALUATION_TYPE'),
		dataIndex: 'revaluationTypeEnum',
		flex:.15,
		sortable:false,
		editor : {
			xtype: 'customcombobox',
			name:'revaluationTypeEnum',
			itemId:'revaluationTypeEnum',
			store:'examCenter.AssignSequence.RevaluationTypeByPeriod',
			valueField : 'value',
			forceSelection:true,
			editable:false,
			typeAhead:false,
			displayField : 'value',
			valueField : 'value',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					/*select: function(combo, record){
						//var grid = combo.up('grid');
						try{ 
							var record = grid.getSelectionModel().getSelection()[0];
							 grid.getSelectionModel().deselect(record);
							 var models = grid.getStore().getRange();
						}
						catch(e){}
					}*/
			 },
			 /*listeners:{
					select: function(combo){
						var grid = combo.view.up().up().grid;
						try{
							grid.getSelectionModel().deselectAll();
						}
						catch(e){}
					}
				}*/
			},
			listeners: {
				select: function() {
					this.up().completeEdit();
				}
			}
		},
		 renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
				if(!isNullOrEmpty(record.data.revaluationTypeEnum)) {
					return getCommonTranslation(record.data.revaluationTypeEnum);
				}else {
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			} else {
				if(record.data.isReturnVoid != undefined && record.data.isReturnVoid){
					var grid = view.up();
					var store = grid.getStore();
					var models = grid.getStore().getRange();
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				} else {
					//var grid = view.up();
					//grid.getSelectionModel().deselect(record);
					
					return getCommonTranslation(val);
				}
			}	
		}
	},{
		header:  getCommonTranslation('START_DATE'),
		dataIndex: 'startDate',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation('END_DATE_LABEL'),
		dataIndex: 'endDate',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation('REVALUATION_STATUS'),
		dataIndex: 'revaluationStatus',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('APPLIED_DATE'),
		dataIndex: 'appliedDate',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation('FEE'),
		dataIndex: 'newFeeAmount',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			var whetherRevalFeeApplicable=null;
			var whetherFeeAmount=null;
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="REVALUATION" ||
					record.data.revaluationTypeEnum=="Revaluation")){
				whetherRevalFeeApplicable=view.up().up().down('#isRevalFeeApplicable').getValue();
				whetherFeeAmount=view.up().up().down('#revalFeeAmount').getValue();
			}
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="REVIEW" ||
					record.data.revaluationTypeEnum=="Review")){
				whetherRevalFeeApplicable=view.up().up().down('#isReviewFeeApplicable').getValue();
				whetherFeeAmount=view.up().up().down('#reviewFeeAmount').getValue();
			}
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="CHALLENGE" ||
					record.data.revaluationTypeEnum=="Challenge")){
				whetherRevalFeeApplicable=view.up().up().down('#isChallengeFeeApplicable').getValue();
				whetherFeeAmount=view.up().up().down('#challengeFeeAmount').getValue();
			}
			if(whetherRevalFeeApplicable=="true"){
				return whetherFeeAmount;
			}else{
				return "-";
			}
			
		} 
	},{
		header:  getCommonTranslation('TRANSACTION_DETAILS'),
		dataIndex: 'documentName',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			var whetherRevalFeeApplicable=null;
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="REVALUATION" ||
					record.data.revaluationTypeEnum=="Revaluation")){
				whetherRevalFeeApplicable=view.up().up().down('#isRevalFeeApplicable').getValue();
			}
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="REVIEW" ||
					record.data.revaluationTypeEnum=="Review")){
				whetherRevalFeeApplicable=view.up().up().down('#isReviewFeeApplicable').getValue();
			}
			if(!isNullOrEmpty(record.data.revaluationTypeEnum) && (record.data.revaluationTypeEnum=="CHALLENGE" ||
					record.data.revaluationTypeEnum=="Challenge")){
				whetherRevalFeeApplicable=view.up().up().down('#isChallengeFeeApplicable').getValue();
			}
			if(!isNullOrEmpty(val) && (whetherRevalFeeApplicable=="true")){
				return "<a href='#'>"+val+"</a>";
			}else{
				return "-";
			}
			
		}   
	},{
		header:  getCommonTranslation('APPROVAL_STATUS'),
		dataIndex: 'approvalStatus',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(record){
			if(!isNullOrEmpty(record) && record=="APPROVED"){
				return "Approved";
			} else if(!isNullOrEmpty(record) && record=="REJECTED"){
				return "Rejected";
			} else{
				return "Pending";
			}
			
		}   
	},{
		header:  getCommonTranslation('REMARKS'),
		dataIndex: 'remark',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	    	if(!isNullOrEmpty(val)){
	    		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;';
	    		return val;
	    	}
	    }
	}],/*
	listeners: {
		beforedeselect: function(sm, record) {
	        var plugin = this.getPlugin();
	        return !plugin.editors.items.length;
	    },
	    beforeselect: function(sm, record) {
	    	var plugin = this.getPlugin();
	        return !plugin.editors.items.length;
	    }
	},*/
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(obj, editor, context){
				if(!isNullOrEmpty(editor.record.data.revaluationStatus) && 
						(editor.record.data.revaluationStatus.toUpperCase()!='NOT APPLIED' ||
								editor.record.data.revaluationStatus.toUpperCase()!='PENDING') &&
						(editor.record.data.revaluationStatus.toUpperCase()=='SUBMITTED'.toUpperCase() || 
						editor.record.data.revaluationStatus.toUpperCase()=='APPLIED'.toUpperCase())){
					return false;
				} else {
					var grid = obj.view.up();
					var store = grid.getStore();
					var models = grid.getStore().getRange();
					var maxCourseEvent = editor.record.data.maxCourseEventToApply, count=0, masterId=[];
					var records = grid.getSelectionModel().getSelection();
					for(var i in models) {
						   if((masterId.length == 0 || 
								   (!isNullOrEmpty(masterId)?masterId.id != models[i].data.examRevaluationId:false))) {
							   masterId.push({
								   "id":models[i].data.examRevaluationId,
								   "bucketSize":models[i].data.maxMasterCount,
								   "revalType" : models[i].data.revaluationTypeEnum
							   })
						   }
					}
					for(j in masterId){
	 					   var maxCount = masterId[j].bucketSize;
	 					   var count=0, selectionMsg='';
	 					  for(var i in models) {
	 						   if(!isNullOrEmpty(models[i].data.revaluationTypeEnum) && masterId[j].id == models[i].data.examRevaluationId
	 								   && (!isNullOrEmpty(records[i]) && records[i].data.admissionId==models[i].data.admissionId)) {
	 							   selectionMsg = models[i].data.revaluationTypeEnum+" "; 
	 							   count++;
	 						   }
	 					  }
         		   }
         		   
         		   if(count>maxCount) {
         			   grid.getSelectionModel().deselect(records[records.length-1]);
         			   var selected = grid.getSelectionModel().getSelection();
         			   if(selected && selected.length){
             			   grid.getSelectionModel().deselect(selected[i]);
         			   }
         			   showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('REVALUATION_TYPE_ACADEMIC_TERM')+' '+selectionMsg.toLowerCase()+' '+
									getExaminationTranslation('REVALUATION_ALLTYPES_WARNING_MSG')+' '+maxCount+' '+ getCommonTranslation('LOWERCASE_COURSES'));
         			 
         			   //cell.checked = false;
         			   //showWarningMessage(getCommonTranslation('ALERT'), "Selection can not be more then " +maxCount+" for "+selectionMsg);
         			    return false;
         		   }
				 }
			},
		}
	}]
});
var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1,
	listeners : {
		beforeedit:function(editor, context, e ){
			console.log(editor);
		}
	}
});