/**
 * Raghavendra.Soni
 **/
var ThesisManagementGridStore = Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementGridStore');
Ext.define('Academia.view.examinationcenters.thesisManagement.FacultyThesisManagementGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.facultythesismanagementgrid',
	store: ThesisManagementGridStore,
	title: getCommonTranslation('THESIS_MANAGEMENT_LIST'),
	border: true,
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'personinfofacultyportal':2
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems: [{
		itemId: 'dockedItemsItemId',
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: ThesisManagementGridStore,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD_NOMINATION"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT_NOMINATION"),
		disabled:true,
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW_NOMINATION"),
		disabled:true,
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnCancelNomination',
		text:getCommonTranslation('CANCEL_NOMINATION'),
		tooltip: getCommonTranslation("CANCEL_NOMINATION"),
		disabled:true
	}, {
		xtype: 'button',
		itemId: 'btnSubmitThesis',
		text:getCommonTranslation('SUBMIT_THESIS'),
		tooltip: getCommonTranslation("SUBMIT_THESIS"),
		disabled:true
	}, {
		xtype: 'button',
		itemId: 'btnApproveReject',
		disabled:true,
		text:getCommonTranslation('APPROVE_REJECT'),
		tooltip: getCommonTranslation("APPROVE_REJECT_THESIS")
	}],
	columns: [{
		header: getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocation',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex: 1,
		sortable: true,
		hidden: true
	}, {
		header: getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex: 1,
		sortable: true,
	}, {
		header: getCommonTranslation('THESIS_STATUS'),
		dataIndex: 'thesisStatus',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				if (value.length == 1) {
					return value[0].docketNo;
				} else if (value.length > 1) {
					return "<a href='#'>" + value+ "</a>";
				}
			}
			return '0';
		}
	}, {
		header: getCommonTranslation('SUPERVISIOR'),
		dataIndex: 'supervisorName',
		flex: 1,
		sortable: true,
		hidden: true,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(record.data.supervisorCount) && record.data.supervisorCount > 1) {
				return "<a href='#'>" + record.data.supervisorCount + "</a>";
			}
			return value;
		}
	}, {
		header: getCommonTranslation('THESIS_DOCUMENT'),
		dataIndex: 'thesisDocument',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(record.raw.thesisDocumentCount) && record.raw.thesisDocumentCount > 0) {
				return "<a href='#'>"+"View Details"+"</a>";
			}else{
				return "-"; 
			}
		}
	}]
});
