/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.examinationcenters.thesisManagement.FacultyThesisManagementSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.facultythesismanagementsearch',  
	plugins : "formlabelrequired",
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    items: [{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'hbox',
    	defaults: {
    		width: 460,
    		labelAlign: 'top'
    	},
    	items : [{
			xtype : 'customcombobox',
			width: 226,
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			store:Ext.create('Academia.store.common.AcademicTermByMappedFacultyVariantStore'),
			valueField : 'id',
			typeAhead : true,
			forceSelection:true,
			allowBlank : false,
		},{
			xtype: 'customcombobox',
			width: 460,
			name: 'thesisManagementStudent',
			itemId:'thesisManagementStudent',
			fieldLabel: getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			store:Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementFacultyPortalStudentStore'),
			editable: true,
			valueField: 'id',
			displayField: 'valueCode',
			forceSelection:true,
			disabled : true,
			minChars:3,
			typeAhead : false,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    	},{
			xtype : 'fieldcontainer',
			width: 'auto',
			defaults : {
				width : 460,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
        		xtype : 'customcombobox',
        		fieldLabel : getProgramandcourseTranslation('SUPERVISOR_NAME'),
        		name : 'supervisorName',
        		itemId : 'supervisorName',
        		store:Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementSupervisorStore'),
        		displayField:'value',
        		valueField:'id',
         		width:226,
        		typeAhead:true,
        		forceSelection:true,
        		minChars:3,
                queryParam:'name',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
	     	},{
        		xtype : 'customcombobox',
        		width: 460,
        		fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
        		name : 'programId',
        		itemId : 'programId',
        		store : Ext.create('Academia.store.attendance.FacultyProgramBatchPeriodStore'),
        		displayField:'valueCode',
        		valueField:'id',
        		typeAhead:true,
        		forceSelection:true,
        		minChars:3,
                queryParam:'programName',
                disabled : true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
	     	}]
    	 },{
        	xtype : 'fieldcontainer',
        	width: 'auto',
        	layout: 'hbox',
        	defaults : {
        		width : 226,
        		labelAlign : 'top'
        	},
        	items : [{
        		xtype: 'customcombobox',
        		name: 'batchId',
        		itemId:'batchId',
        		fieldLabel : getCourseTxCommonTranslation('BATCH'),
        		disabled:true,
        		store: Ext.create('Academia.store.attendance.FacultyProgramBatchPeriodStore'),
        		valueField: 'id',
        		displayField: 'value',
        		typeAhead:true,
        		forceSelection:true,
        		editable : false
        	},{
        		xtype: 'customcombobox',
        		name: 'periodId',
        		itemId:'periodId',
        		fieldLabel: getExaminationTranslation('PERIOD'),
        		store:Ext.create('Academia.store.attendance.FacultyProgramBatchPeriodStore'),
        		displayField:'value',
        		valueField:'id',
        		forceSelection:true,
        		disabled : true,
        		typeAhead:true,
        		editable : false
        	}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				width : 226,
				fieldLabel: getProgramandcourseTranslation('THESIS_STATUS'),
				store:Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisStatusEnumStore'),
				name:'thesisStatus',
				itemId: 'thesisStatus',
				displayField: 'value',
				valueField: 'value',
				forceSelection:true,
				queryMode:'local'
			},{
				xtype: 'customcombobox',
				width : 226,
				fieldLabel: getProgramandcourseTranslation('ACCESS_MODE'),
				store:Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementAccessModeStore'),
				name:'accessMode',
				itemId: 'accessMode',
				displayField: 'code',
				valueField: 'id',
				forceSelection:true,
				hidden:true,
				queryMode:'local'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('FROM_DATE'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				vtype : 'daterange',
				//maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					change: function(me, newValue, oldValue, eOpts) {
						if(!isNullOrEmpty(newValue))
						{
    						var date = me.parseDate(newValue);
    						var startDate = me.up().down("#startDate");
    						var end = me.up().down("#tillDate");
    						var newDate = date.setMonth(date.getMonth()+6);
	                    	newDate = new Date(newDate);
	                    	end.setMaxValue(newDate);
	                    	startDate.isValid();
						}
					}
				}
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('END_DATE'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				vtype : 'daterange',
				//maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					change: function(me, newValue, oldValue, eOpts) {
						if(!isNullOrEmpty(newValue))
						{
    						var date = me.parseDate(newValue);
    						var startDate = me.up().down("#startDate");
    						var endDate = me.up().down("#tillDate");
	                    	var newDate = date.setMonth(date.getMonth()-6);
	                    	newDate = new Date(newDate);
	                    	startDate.setMinValue(newDate);
	                    	endDate.isValid();
						}
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'programSearchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
