/**
 *  @author Deepak S
 */

Ext.define('Academia.view.facilitiesresources.managegallery.MapFolderAddProgramBatchSectionGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.mapfolderaddprogrambatchsectiongrid',
	title : getCommonTranslation('SECTION'),
	store: 'facilitiesresources.managegallery.MapFolderALProgramBatchSectionStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		deferEmptyText: false,
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	emptyText: getCommonTranslation('NORESULTSNMESSAGE'),
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitMapping',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionName',
		flex : 1	 
	}]
});