/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show adhoc resources details Dialog box.
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormAdhocResourceWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.adhocresourceformwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('ADHOC_RESOURCE'), //Adhoc Resource 		
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'adhocresourceForm',
        plugins: "formlabelrequired",
        method: 'POST',
        margin: 0,
        bodyPadding: '10 10 10 10',
        standardSubmit: false,
        items: [{
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'hidden',
                itemId: 'adhocresource_hidden_field',
                name: 'id'
            }, {
                xtype: 'hidden',
                itemId: 'client_Id_hidden_field',
                name: 'client_Id'
            }, {
                xtype: 'hidden',
                itemId: 'version_hidden_field',
                name: 'version'
            }, {
                xtype: 'customcombobox',
                name: 'resourceType',
                itemId: 'cmbResourceType',
                fieldLabel: getCommonTranslation('RESOURCE_TYPE'), //Resource Type
                store: 'facilitiesresources.resourcebooking.ResourceTypeStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true,
                allowBlank: false
            }, {
                xtype: 'nestedJsonCombo',
                name: 'internalUser',
                itemId: 'assignInternalUser',
                fieldLabel: getCommonTranslation('ASSIGN_INTERNAL_USER'), //Assign Internal User
                store: 'common.ActiveUserStore', //common.UsersComboStore
                valueField: 'id',
                displayField: 'valueCode',
                editable: false,
                //queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                fieldLabel: getCommonTranslation('RESOURCE_NAME'), //Resource Name
                xtype: 'textfield',
                itemId: 'resourceName',
                name: 'resourceName',
                maxLength:10,
                allowBlank: false
            }, {
                xtype: 'numberfield',
                itemId: 'quantity',
                name: 'quantity',
                fieldLabel: getCommonTranslation('QUANTITY'), //Quantity
                minValue:0,
                maxLength: 5
            }]
        }, {
            xtype: 'checkboxfield',
            boxLabel: getCommonTranslation('AVAIL'), //Availability Confirmed
            name: 'isConfirmed',
            inputValue: true,
            uncheckedValue: false,
            itemId: 'chkAvail'
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'textareafield',
                name: 'description',
                fieldLabel: getCommonTranslation('DESC'), //Description
                maxLength: 250
            }, {
                xtype: 'textareafield',
                name: 'remark',
                itemId:'remark',
                labelAlign: 'top',
                fieldLabel: getCommonTranslation('REMARKS'), //Remarks
                maxLength: 250
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveAdhocResourceForm',
                text: getCommonTranslation('SAVE'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelAdhocResourceForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});