/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show selected facilities or selected resources.   
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormFacilitySelectedPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.resourcebookingformfacilityselectedpanel',
    title: getCommonTranslation('SELECTED_FACILITIES'), //Facilities Selected
    autoScroll: true,
    frame: true,
    border: false,
    collapsible: true,
    collapseDirection: 'right',
    region: 'east',
    initComponent: function() {
        var tpl = new Ext.XTemplate('<table  cellpadding="0" cellspacing="0" width="100%">', '<ul><tpl for=".">', '<tr align="left">', '<td><li>{selectedText}</li></td>', '</tr>', '</tpl></ul>', '</table>');
        var dataView = Ext.create('Ext.DataView', {
            autoScroll: true,
            padding: 5,
            itemId: 'selectedFacilitiesPanel',
            store: Ext.create('Academia.store.facilitiesresources.resourcebooking.SelectedFacilitiesStore'),
            tpl: tpl
        });
        this.items = dataView;
        this.callParent(arguments);
    }
});