/**
 *  @author Niklesh T
 * 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.alumniEventRegistrationDetails.AlumniEventRegistrationDetailsFilter',{
	extend: 'Ext.form.Panel',
	alias : 'widget.alumnieventregistrationdetailsfilter',
	autoScroll: false,
	bodyPadding:'10 10 10 11',
	frame:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
//	style:{
//		marginLeft:"8px"
//	},

	defaults: {
		labelAlign: 'top',
	},
	items:[{
        xtype: 'fieldcontainer',
        width : '100%',
		layout: {
			type : 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},		
        items: [{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('ALUMNI_NAME'),
				name: 'alumniName',
				itemId:'alumniNameItemId',
				minChars:3,
				forceSelection:true,
				store: 'alumni.alumniEventRegistrationDetails.AlumniNameStore',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
	        },{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('ALUMNI_ID'),
				name:'alumniId',
				itemId:'alumniItemId',
				forceSelection: true,
				minChars:3,
				store: 'alumni.alumniEventRegistrationDetails.AlumniIDStore',
				forceSelection:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'code',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			},{
				xtype : 'customcombobox',
				fieldLabel : getAlumni('ACADEMY_LOCATION'),		
				name : 'alumniAlName',
				itemId : 'alumniAlItemId',	
				store:Ext.create('Academia.store.alumni.alumniEventRegistrationDetails.AlumniALStore'),
				forceSelection:true,					
				valueField: 'id',
				displayField: 'value',
				queryParam:'query',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
				}],			
    	},{
    		xtype: 'fieldcontainer',    
    		layout: {
    			type : 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},	
    		items : [
    			{
	    				xtype: 'customcombobox',
	    				fieldLabel:getAlumni('PROGRAM'),
	    				name:'alumniProgram',
	    				itemId:'alumniProgramItemId',
	    				//store:Ext.create('Academia.store.facilitiesresources.resourcemaster.ProgramGridStore'),
	    				store: Ext.create("Academia.store.common.ProgramStore"),
	    				forceSelection: true,
	    				valueField: 'id',
						displayField: 'value',
	    				minChars:3,
	    				disabled: true,
	    				listConfig: {
	    					listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	        				loadingText: getCommonTranslation('SEARCHING'),
	        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        			}	
					},
//					{
//						xtype: 'customcombobox',
//						fieldLabel:getAlumni('REGISTRATION_ID:'),
//						name: 'registrationId',
//						itemId:'registrationIdItemId',
//						minChars:3,
//						forceSelection:true,
//						//store: 'alumni.alumniList.	AlumniIDStore',
//						triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
//						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
//						valueField: 'value',
//						displayField: 'value',
//						queryParam:'alumniCode',
//						listConfig: {
//							listeners: {
//		    					beforeshow: function(picker) {
//		    						picker.minWidth = picker.up('combobox').getSize().width;
//		    					}
//		    				},
//		    				loadingText: getCommonTranslation('SEARCHING'),
//		    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
//		    			}
//			        },
			        {
	                	xtype: 'datefield',
	        			name: 'registrationDate',
	        			itemId: 'registrationDate',
	        			fieldLabel: getAlumni('REGISTRATION_DATE'),
	        			listeners: {
	        				render: function(field) {
	        					return dateFormatRender(field);
	        				}
	        			}
	        		
					}
				]
    		
    	},{
    		xtype: 'fieldcontainer',    
    		layout : {
    			type : 'hbox'
    		},
    		width:'auto',
    		items : [{
    			xtype : 'button',
    			text : getCommonTranslation("SEARCH") ,
    			name : 'submitBtn',
    			itemId : 'submitBtn',
    			ui : 'CustomBtnSubmit',
    			scale : CONSTANTS.BUTTONSIZE,
    			formBind : true
    		},{
    			xtype: 'button',
    			itemId: 'resetBtn',
    			name: 'resetBtn',
    			text: getCommonTranslation("RESET"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE,
    		}]
    	
    	}]
});

