/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.fdmanagement.facultyPortal.FDMEGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.fdmegrid',
	store: 'fdmanagement.FDManagementStore',
	title: getServiceRequestTranslation('FD_LIST_OF_RECEIVED_ITEMS'),
	border: true,
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		itemId: 'dockedItemsItemId',
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'fdmanagement.FDManagementStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar: [{

		xtype: 'button',
		itemId: 'btnUpdateStatusItemId',
		tooltip: getServiceRequestTranslation('FD_UPDATE_ACKNOWLEDGEMENT_STATUS'),
		text: getServiceRequestTranslation('FD_UPDATE_ACKNOWLEDGEMENT_STATUS'),
		scale: CONSTANTS.BUTTONSIZE,
		style: {
			marginRight: '10px'
		}
	}],
	columns: [{
		header: getServiceRequestTranslation('FD_ITEM_CATEGORY'),
		dataIndex: 'itemCategory',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			return value.value;
		}
	}, {
		header: getServiceRequestTranslation('FD_INWARD_NO'),
		dataIndex: 'inwardNo',
		flex: 1,
		sortable: true
	}, {
		header: getServiceRequestTranslation('FD_SENDER'),
		dataIndex: 'senderName',
		flex: 1,
		sortable: true
	}, {
		header: getServiceRequestTranslation('FD_SENDER_CONTACT_NO'),
		dataIndex: 'senderContactNo',
		flex: 1,
		sortable: true
	}, {
		header: getServiceRequestTranslation('FD_DOCKET_NO'),
		dataIndex: 'fdItemDetails',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				if (value.length == 1) {
					return value[0].docketNo;
				} else if (value.length > 1) {
					return "<a href='#'>" + value.length + "</a>";
				}
			}
			return '0';
		}
	}, {
		header: getServiceRequestTranslation('FD_RECEIVING_DATE'),
		dataIndex: 'deliveryDate',
		flex: 1,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getServiceRequestTranslation('FD_ACK_STATUS'),
		dataIndex: 'acknowledgeStatus',
		flex: 1,
		sortable: true
	}, {
		header: getServiceRequestTranslation('FD_ACK_DATE'),
		dataIndex: 'acknowledgmentDate',
		flex: 1,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getServiceRequestTranslation('FD_BILL_NO'),
		dataIndex: 'billNo',
		flex: 1,
		sortable: true
	}, {
		header: getServiceRequestTranslation('FD_BILL_AMOUNT'),
		dataIndex: 'billAmount',
		flex: 1,
		sortable: true
	}, {
		header: getServiceRequestTranslation('FD_ATTACHMENTS'),
		dataIndex: 'fdItemDocuments',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				if (value.length > 0) {
					return "<a href='#'>" + value.length + "</a>";
				}
			}
			return '0';
		}
	}, {
		header: getServiceRequestTranslation('FD_RECEIVER_REMARKS'),
		dataIndex: 'receiverRemarks',
		flex: 1,
		sortable: true,
		hidden: true
	}]
});