/**
 *  @author Rajkumar.patidar
 */


Ext.define('Academia.view.feeandpayment.AssociateStudentUserListForService', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.associatestudentuserlistforservice',
	store : 'feeandpayment.UserForServiceFeePlan',
	title: getFeeAndPaymentCommonTranslation('LIST_OF_STUDENT'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.UserForServiceFeePlan',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('NAME'),
		dataIndex : 'userName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('ID'),
		dataIndex : 'userId',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex:1
/*	},{
		header : getFeeAndPaymentCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1*/
	},{
		header : getFeeAndPaymentCommonTranslation('STAGE'),
		dataIndex : 'stageName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_PLAN_SEQUENCE'),
		dataIndex : 'feeRuleDesc',
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}                        
		},
		flex:1
	}]
});