/**
 * @author SudarshanReddy
 */

Ext.define('Academia.view.feeandpayment.DependedFeeHeadWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.dependedfeeheadwin',
	title:getFeeAndPaymentCommonTranslation('DEPENDED_FEE_HEADS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	maxHeight: 600,
	items: [{
		xtype: 'form',
		bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
				xtype: 'hidden',
				name: 'id'
		      },{
				xtype: 'customcombobox',
			    name: 'dependantFeeHead',
			    itemId:'dependantFeeHead',
			    fieldLabel: getFeeAndPaymentCommonTranslation('DEPENDED_FEE_HEADS'),
			    store: 'feeandpayment.DependedFeeHead',
			    valueField: 'id',
			    displayField: 'value',
			    allowBlank: false,
			    typeAhead:true,
			    forceSelection:true
			},{
				xtype: 'customcombobox',
			    name: 'amountType',
			    itemId:'amountType',
			    fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT_FOR'),
			    store: 'feeandpayment.FeeAmount',
			    valueField: 'id',
			    displayField: 'value',
			    allowBlank: false,
			    typeAhead:true,
			    forceSelection:true
			},{
				xtype: 'numberfield',
				name: 'amount',
				minValue:0,
				maxLength:10,
				hideTrigger:true,
				itemId:'amount',
				fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT'),
			    allowBlank:false
		   },{
			   xtype:'numberfield',
			   name:'percentageValue',
			   fieldLabel:getFeeAndPaymentCommonTranslation('FEE_PERCENTAGE'),
			   minValue:0,
			   maxValue:100,
			   hideTrigger:true,
			   itemId:'percentageValue',
			   enforceMaxLength : true,
			   hidden:true,
			   allowBlank:true
		   },{
				xtype: 'textfield',
				name: 'farmula',
				hidden:true,
				itemId:'farmula',
				fieldLabel: getFeeAndPaymentCommonTranslation('FARMULA'),
			    //allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'feeThirdParties',
				itemId:'feeThirdParties',
				allowBlank:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('THIRD_PARTY_CODE_NAME'),
				store: 'feeandpayment.managebill.ThirdParties',
				valueField: 'id',
				displayField: 'printName',
				queryParam:'codeOrPrintName',
				//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				//minChars:3,
				typeAhead:false,
	            hideTrigger:false,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{code} / {printName}' +
		                    '</div>';
		                }
		            }
				
			},{
				
				 xtype:'fieldcontainer',
				 defaults: {
						labelAlign: 'top',
						width:226
					},
				 items:[{
						xtype: 'radiogroup',
						itemId:'whetherInclusive',
						fieldLabel: getFeeAndPaymentCommonTranslation('SHOW_IN_BILL'),
						columns: 2,
						vertical: true,
						items: [
						        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherInclusive', inputValue: true,checked:true},
						        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherInclusive', inputValue: false}
						        ]
					}]
			},{	
			/*	xtype: 'customcombobox',
			    name: 'feeThirdParties',
			    itemId:'feeThirdParties',
			    fieldLabel: getFeeAndPaymentCommonTranslation('FEE_THIRD_PARTIES'),
			    store: 'feeandpayment.FeeThirdParties',
			    valueField: 'id',
			    displayField: 'code',
			    allowBlank: false,
			    typeAhead:true,
			    forceSelection:true
			},{
				    xtype: 'textfield',
					itemId:'thirdPartyName',
					name:'thirdPartyName',
					fieldLabel: getFeeAndPaymentCommonTranslation('THIRD_PARTY_NAME'),
				    allowBlank:false ,
				    readOnly:true
		
		 },{*/	
			  xtype:'fieldcontainer',
			  //width:'100%',
			  cls:'windowBtnPos',
			  items: [{
			    	 xtype: 'button',
					 action: 'Submit',
					 text: getFeeAndPaymentCommonTranslation('SAVE'),
					 formBind: true,
					 itemId: 'SubmitBtn',
					 ui: 'CustomBtnSubmit',
					 scale: CONSTANTS.BUTTONSIZE
			       },{
					 xtype: 'button',
					 text: getFeeAndPaymentCommonTranslation('CANCEL'),
					 ui: 'CustomBtnCancel',
					 itemId: 'CancelBtn',
					 scale: CONSTANTS.BUTTONSIZE
			      }]
		}]	
	}]
});